package ru.yandex.autotests.direct.web.steps;

import ru.yandex.autotests.direct.web.pages.superpages.IinternalReportsPage;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import static ru.yandex.qatools.allure.webdriver.pages.BasePageObject.withParameters;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class IinternalReportsPageSteps extends BaseSteps {

    public IinternalReportsPage onIinternalReportsPage() {
        return IinternalReportsPage.getInstance(IinternalReportsPage.class, config);
    }

    @Step
    public void shouldSeeVATValue(String login, String value) {
        onIinternalReportsPage().open("open.client_nds_schedule", withParameters(login));
        onIinternalReportsPage().checkVATValue(value);
    }

}
