package ru.yandex.autotests.direct.web.steps;

import ru.yandex.autotests.direct.web.data.CampaignTypeEnum;
import ru.yandex.autotests.direct.web.pages.CampaignChooseBlock;
import ru.yandex.autotests.direct.web.pages.MenuHeaderBlock;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;
import ru.yandex.qatools.htmlelements.loader.HtmlElementLoader;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;

/**
 * User: buhter
 * Date: 17.09.12
 * Time: 11:04
 */
public class MenuHeaderSteps extends BaseSteps {

    private MenuHeaderBlock loadMenuHeaderBlock() {
        return HtmlElementLoader.create(MenuHeaderBlock.class, config.getDriver());
    }

    private CampaignChooseBlock loadCampaignChooseBlock() {
        return HtmlElementLoader.create(CampaignChooseBlock.class, config.getDriver());
    }

    @Step("Кликаем по ссылке Дать объявление")
    public void clickAddBannerLink() {
        loadMenuHeaderBlock().clickOnAddBannerLink();
    }

    @Step("Кликаем по ссылке Создать компанию типа {0}")
    private void clickAddCampaignLink(CampaignTypeEnum campaignTypeEnum) {
        loadMenuHeaderBlock().clickOpenCampaignCreatePopup();
        switch (campaignTypeEnum) {
            case TEXT:
                loadCampaignChooseBlock().clickOnAddTextCampaignLink();
                break;
            case MOBILE:
                loadCampaignChooseBlock().clickOnAddMobileCampaignLink();
                break;
            case DMO:
                loadCampaignChooseBlock().clickOnAddPerformanceCampaignLink();
                break;
            case MC:
                loadCampaignChooseBlock().clickOnAddMcCampaignLink();
        }
    }

    public void clickAddTextCampaign() {
        clickAddCampaignLink(CampaignTypeEnum.TEXT);
    }

    public void clickAddMobileCampaign() {
        clickAddCampaignLink(CampaignTypeEnum.MOBILE);
    }

    public void clickAddPerformanceCampaign() {
        clickAddCampaignLink(CampaignTypeEnum.DMO);
    }

    public void clickOnAddMcCampaignLink() {
        clickAddCampaignLink(CampaignTypeEnum.MC);
    }

    @Step
    public void clickSearch() {
        loadMenuHeaderBlock().clickOnSearchLink();
    }

    @Step
    public void clickMyCampaigns() {
        loadMenuHeaderBlock().clickOnMyCampaignsLink();
    }

    @Step
    public void failedStep() {
        assertThat(true, equalTo(false));
    }
}

