package ru.yandex.autotests.direct.web.steps;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;

import ru.yandex.autotests.direct.web.pages.MordaPage;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;
import ru.yandex.qatools.htmlelements.element.Button;

/**
 * Created by shmykov on 24.06.14.
 */
public class MordaPageSteps extends BaseSteps {

    public MordaPage onMordaPage() {
        return MordaPage.getInstance(MordaPage.class, config);
    }

    @Step("Кликаем по кнопке 'Разместить рекламу' вверху страницы")
    public void placeAdInHeader() {
        onMordaPage().clickOnPlaceAdHeadButton();
    }

    @Step("Кликаем по кнопке 'Разместить рекламу' внизу страницы")
    public void placeAdInBottom() {
        onMordaPage().clickOnPlaceAdBottomButton();
    }

    @Step("Проверяем, что домик авторизации соответствует {0}")
    public void shoudSeeDomik(Matcher<WebElement> matcher) {
        onMordaPage().checkDomik(matcher);
    }

    @Step("Проверка что кнопка 'Разместить рекламу' соответствует {0}")
    public void shouldSeePlaceAdButton(Matcher<Button> matcher) {
        onMordaPage().checkPlaceAdHeadButton(matcher);
    }
}
