package ru.yandex.autotests.direct.web.steps;

import ru.yandex.autotests.direct.utils.clients.tus.TusClient;
import ru.yandex.autotests.direct.utils.clients.tus.TusCreateAccountResponse;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.annotations.WithoutScreenshot;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

/**
 * @author xy6er
 * Date: 30.08.13
 * Класс для вызова апишных методов паспорта
 */
public class PassportApiSteps extends BaseSteps {

    private static PassportApiSteps instance = null;

    public static PassportApiSteps getInstance() {
        if (instance == null) {
            instance = new PassportApiSteps();
        }
        return instance;
    }

    private final TusClient tusClient = new TusClient();

    @Step("Создание дефолтного юзера в паспотре используя TUS")
    @WithoutScreenshot
    public User createNewUser() {
        TusCreateAccountResponse regUser = tusClient.createAccount();
        User user = new User();
        user.setLogin(regUser.getAccount().getLogin());
        user.setPassword(regUser.getAccount().getPassword());
        return user;
    }

    @Step("Создание дефолтного юзера {0} с паролем {1} в паспотре используя TUS")
    @WithoutScreenshot
    public User createNewUser(String login, String password) {
        TusCreateAccountResponse regUser = tusClient.createAccount(login, password);
        User user = new User();
        user.setLogin(regUser.getAccount().getLogin());
        user.setPassword(regUser.getAccount().getPassword());
        return user;
    }
}
