package ru.yandex.autotests.direct.web.steps;


import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.web.pages.PassportPage;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.annotations.WithoutScreenshot;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class PassportUserSteps extends BaseSteps {

    private PassportPage onPassportPage() {
        return PassportPage.getInstance(PassportPage.class, config);
    }

    /**
     * Выполняет авторизацию пользотеля на паспорте по прямой ссылке
     * и открывает заданную страницу
     *
     * @param login    логин пользователя
     * @param password пароль пользователя
     * @param host     адрес страницы, на которую следует перейти после авторизации
     */
    @Step("Заполняем логин {0} и пароль {1} на паспорте. Редиректимся на {2}")
    @WithoutScreenshot
    public void getsPassportAuth(String login, String password, String host) {
        onPassportPage().openPassportPageAndLogin(login, password);
        config.getDriver().get(host);
    }

    @Step("Заполняем логин {0} и пароль {1} на паспорте.")
    @WithoutScreenshot
    public void getsPassportAuth(String login, String password) {
        onPassportPage().login(login, password);
    }

    @Step("Открываем страницу паспорта")
    public void openPassportPage() {
        onPassportPage().openPassport();
    }

    @Step("Разлогиниваемся (везде={0})")
    public void logout() {
        // <значение-куки-yandexuid> -https://wiki.yandex-team.ru/passport/modes#logout
        String yandexuid = config.getDriver().manage().getCookieNamed("yandexuid").getValue();
        String logoutUrl =
                String.format(
                        "https://passport.yandex.ru/passport?mode=logout&yu=%s&retpath=%s",
                        yandexuid,
                        DirectTestRunProperties.getInstance().getDirectCmdHost());
        // https://passport.yandex.ru/passport?mode=logout&global=1&yu=558668131435234290&idkey=4F71435235860soEiRW5RO
        config.getDriver().get(logoutUrl);

    }
}
