package ru.yandex.autotests.direct.web.steps;

import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.objects.campaigns.CampaignInfoWeb;
import ru.yandex.autotests.direct.web.pages.superpages.ShowSearchPage;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

public class ShowSearchPageSteps extends BaseSteps {

    private ShowSearchPage onShowSearchPage() {
        return ShowSearchPage.getInstance(ShowSearchPage.class, config);
    }

    @Step
    public void searchClientOrAgency(String login) {
        onShowSearchPage().fillLoginInput(login);
        onShowSearchPage().clickOnSearchClientsAndAgenciesButton();
    }

    @Step
    public void searchCampaign(String campaignID) {
        onShowSearchPage().fillCampaignIDInput(campaignID);
        onShowSearchPage().clickOnSearchCampaignsButton();
    }

    @Step
    public void shouldSee(BeanEquals<AccountWeb> matcher) {
        onShowSearchPage().checkSearchAccount(matcher);
    }

    @Step
    public void shouldSeeCampaign(BeanEquals<CampaignInfoWeb> matcher) {
        onShowSearchPage().checkSearchCampaign(matcher);
    }
}
