package ru.yandex.autotests.direct.web.steps.agencies;

import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.objects.campaigns.CampaignInfoWeb;
import ru.yandex.autotests.direct.web.pages.agencies.AgSearchPage;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

public class AgSearchPageSteps extends BaseSteps {

    private AgSearchPage onAgSearchPage() {
        return AgSearchPage.getInstance(AgSearchPage.class, config);
    }

    @Step("Ищем логин {0}")
    public void searchClient(String login) {
        onAgSearchPage().searchClient(login);
    }

    @Step("Ищем кампанию {0}")
    public void searchCampaign(String campaignID) {
        onAgSearchPage().searchCampaign(campaignID);
    }

    @Step("Проверяем данные клиента")
    public void shouldSeeClient(BeanEquals<AccountWeb> matcher) {
        AllureUtils.addTextAttachment("Ожидаемые данные клиента", matcher.toString());
        onAgSearchPage().checkSearchClient(matcher);
    }

    @Step("Проверка данных кампании")
    public void shouldSeeCampaign(BeanEquals<CampaignInfoWeb> matcher) {
        AllureUtils.addTextAttachment("Ожидаемые данные кампании", matcher.toString());
        onAgSearchPage().checkSearchCampaign(matcher);
    }
}
