package ru.yandex.autotests.direct.web.steps.api;

import ru.yandex.autotests.direct.web.data.api.APIRoleEnum;
import ru.yandex.autotests.direct.web.pages.api.APISandboxSettingsPage;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.allure.webdriver.steps.AlertSteps;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

/**
 * Created by proxeter (Nikolay Mulyar - proxeter@yandex-team.ru) on 14.05.2014.
 */
public class ApiSandboxSettingsPageSteps extends BaseSteps {

    private APISandboxSettingsPage onApiSandboxSettingsPage() {
        return BasePageObject.getInstance(APISandboxSettingsPage.class, config);
    }

    private AlertSteps onAlert() {
        return getInstance(AlertSteps.class, config);
    }

    @Step("Нажатие на кнопку 'Начать пользоваться песочницей'")
    public void clickStartUseSandboxLink() {
        onApiSandboxSettingsPage().clickStartUseSandboxLink();
    }

    @Step("Выбор роли {0}")
    public void selectRole(APIRoleEnum role) {
        onApiSandboxSettingsPage().selectRole(role);
    }

    @Step("Выбор 'Создать тестовые кампании' {0}")
    public void selectCreateTestCampaigns(Boolean status) {
        onApiSandboxSettingsPage().selectCreateTestCampaigns(status);
    }

    @Step("Нажатие на кнопку 'Продолжить'")
    public void clickContinueButton() {
        onApiSandboxSettingsPage().clickContinueButton();
    }

    @Step("Получение мастер-токена песочницы")
    public String getSandboxMasterToken() {
        return onApiSandboxSettingsPage().getSandboxMasterTokenValue();
    }

    @Step("Нажатие на ссылку 'Перестать пользоваться песочницей'")
    public void clickStopUseSandboxLink() {
        onApiSandboxSettingsPage().clickStopUseSandboxLink();
    }

    @Step("Нажатие на кнопку 'Перестать пользоваться песочницей', если она отображена")
    public void clickStopUseSandboxIfDisplayed() {
        if (onApiSandboxSettingsPage().clickStopUseSandboxIfDisplayed()) {
            clickStopUseSandboxLink();
        }
    }

}
