package ru.yandex.autotests.direct.web.steps.api;

import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.web.pages.api.APISettingsPage;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import static org.hamcrest.MatcherAssert.assertThat;

public class ApiSettingsPageSteps extends BaseSteps {

    private APISettingsPage onApiSettingsPage() {
        return BasePageObject.getInstance(APISettingsPage.class, config);
    }

    public void clickSandboxLink() {
        onApiSettingsPage().clickSandboxLink();
    }

    public void clickFinanceSettingsLink() {
        onApiSettingsPage().clickFinanceSettingsLink();
    }


    @Step("Получаем текст заголовка страницы")
    public String getHeaderText() {
        return onApiSettingsPage().getHeader().getText();
    }


    @Step("Проверяем, что текст заголовка соответствует {0}")
    public void checkHeaderText(Matcher matcher) {
        assertThat("текст заголовка не соответствует ожиданию", getHeaderText(), matcher);
    }
}
