package ru.yandex.autotests.direct.web.steps.autopayment;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;

import ru.yandex.autotests.direct.web.objects.autopayment.AutoPaymentWeb;
import ru.yandex.autotests.direct.web.pages.autopayment.AutoPaymentPage;
import ru.yandex.autotests.direct.web.steps.CommonSteps;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.not;
import static ru.yandex.autotests.direct.web.util.matchers.webdriver.HasURL.hasURL;

public class AutoPaymentPageSteps extends BaseSteps {

    private AutoPaymentPage onAutoPaymentPage() {
        return AutoPaymentPage.getInstance(AutoPaymentPage.class, config);
    }

    private CommonSteps getCommonSteps() {
        return CommonSteps.getInstance(CommonSteps.class, config);
    }

    public BindCardSteps onBindCardBlock() {
        return BindCardSteps.getInstance(BindCardSteps.class, config);
    }

    @Step("Заполняем поля страницы автопополнения")
    public void fillAutoPaymentParameters(AutoPaymentWeb autoPayment) {
        AllureUtils.addJsonAttachment("Параметры автопополнения", JsonUtils.toString(autoPayment));
        onAutoPaymentPage().fillParameters(autoPayment);
    }

    @Step("Сохраняем автопополнение")
    public void clickSaveAutoPayment() {
        String currentURL = config.getDriver().getCurrentUrl();
        onAutoPaymentPage().clickSaveAutoPayment();
        getCommonSteps().shouldSeeBrowser(not(hasURL(equalTo(currentURL))));
    }

    @Step("Проверяем параметры страницы автопополнения")
    public void checkAutoPaymentParameters(BeanDifferMatcher<AutoPaymentWeb> matcher) {
        AllureUtils.addJsonAttachment("Параметры автопополнения", JsonUtils.toString(matcher.getExpectedBean()));
        onAutoPaymentPage().checkParameters(matcher);
    }

    @Step("Открываем попап добавления карты")
    public void clickShowAddCard() {
        onAutoPaymentPage().clickShowAddCard();
    }

    @Step("Проверяем состояние попапа привязки карты")
    public void shouldSeeBindCardBlock(Matcher<WebElement> matcher) {
        onAutoPaymentPage().shouldSeeBindCardBlock(matcher);
    }

    @Step("Получаем чек-бокс согласия с Офертой")
    public CheckBoxBEM getOfertaCheckbox() {
        return onAutoPaymentPage().getOfertaCheckBox();
    }

    @Step("Получаем ссылку на договор Оферты")
    public WebElement getOfertaLink() {
        return onAutoPaymentPage().getOfertaLink();
    }
}
