package ru.yandex.autotests.direct.web.steps.autopayment;

import org.openqa.selenium.By;

import ru.yandex.autotests.direct.web.objects.autopayment.CardWeb;
import ru.yandex.autotests.direct.web.pages.autopayment.BindCardPage;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import static org.hamcrest.Matchers.not;
import static ru.yandex.qatools.htmlelements.matchers.WebElementMatchers.isDisplayed;

public class BindCardSteps extends BaseSteps {

    private BindCardPage onBindCardPage() {
        return BindCardPage.getInstance(BindCardPage.class, config);
    }

    public void switchToPage() {
        config.getDriver().switchTo().frame(config.getDriver()
                .findElement(By.xpath("//iframe[contains(@src, 'cmd=ajaxGetBindingForm')]")));
        onBindCardPage().waitForSpinLoader(not(isDisplayed()));
    }

    private void switchToCardForm() {
        config.getDriver().switchTo().frame(config.getDriver()
                .findElement(By.cssSelector("iframe.popup__iframe")));
    }

    @Step("Заполняем параметры карты")
    public void fillCardParameters(CardWeb card) {
        AllureUtils.addJsonAttachment("Параметры карты", JsonUtils.toString(card));

        switchToCardForm();
        onBindCardPage().fillParameters(card);
        config.getDriver().switchTo().parentFrame();
    }

    @Step("Нажимаем на привязать карту")
    public void clickSubmitCardButton() {
        onBindCardPage().clickSubmitButton();
    }

}
