package ru.yandex.autotests.direct.web.steps.banners;

import java.util.List;

import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.web.data.BannerPreviewType;
import ru.yandex.autotests.direct.web.data.banners.BannersGroupErrorResource;
import ru.yandex.autotests.direct.web.data.banners.ImageLoadType;
import ru.yandex.autotests.direct.web.data.banners.MobileGroupChangesBlockTabs;
import ru.yandex.autotests.direct.web.data.banners.MobileGroupChangesInfo;
import ru.yandex.autotests.direct.web.objects.adjustment.rates.HierarchicalMultipliersWeb;
import ru.yandex.autotests.direct.web.objects.banners.BannerPhraseInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.MobileAppBannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.OptimizedPhraseInfoWeb;
import ru.yandex.autotests.direct.web.objects.retargeting.RetargetingConditionWeb;
import ru.yandex.autotests.direct.web.pages.banners.AddAdGroupsMobileContentPage;
import ru.yandex.autotests.direct.web.steps.AlertSteps;
import ru.yandex.autotests.direct.web.steps.BackendSteps;
import ru.yandex.autotests.direct.web.steps.CaptchaPopupSteps;
import ru.yandex.autotests.direct.web.steps.CommonSteps;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.Matchers.allOf;
import static ru.yandex.autotests.direct.utils.beans.BeanWrapper.wrap;
import static ru.yandex.autotests.direct.web.util.OperationSystemUtils.sleep;
import static ru.yandex.autotests.direct.web.util.matchers.webdriver.HasURL.hasURL;
import static ru.yandex.qatools.htmlelements.matchers.WebElementMatchers.exists;
import static ru.yandex.qatools.htmlelements.matchers.WebElementMatchers.hasAttribute;

/**
 * Created by aleran on 11.09.2015.
 */
public class AddAdGroupsMobileContentPageSteps extends BaseSteps {

    private AddAdGroupsMobileContentPage onAddAdGroupsMobileContentPage() {
        return AddAdGroupsMobileContentPage.getInstance(AddAdGroupsMobileContentPage.class, config);
    }

    public CommonSteps getCommonSteps() {
        return CommonSteps.getInstance(CommonSteps.class, config);
    }

    public CaptchaPopupSteps inCaptchaPopup() {
        return CaptchaPopupSteps.getInstance(CaptchaPopupSteps.class, config);
    }

    private void addAdGroupsMobileContentPageForParameters(Long bannerId) {
        addAdGroupsMobileContentPageForParameters(bannerId, null);
    }

    private void addAdGroupsMobileContentPageForParameters(Long bannerId, Long adGroupID) {
        onAddAdGroupsMobileContentPage().forBannerId(bannerId);
        if (adGroupID == null) {
            if (bannerId == null || bannerId.equals(0L)) {
                adGroupID = 0L;
            } else {
                adGroupID = new BackendSteps().getAdGroupIdByBannerId(bannerId);
            }
        }
        onAddAdGroupsMobileContentPage().forAdGroupId(adGroupID);
    }

    @Step("Нажимаем назад")
    public void goBack() {
        onAddAdGroupsMobileContentPage().clickBack();
    }

    @Step("Нажимаем вперед")
    public void goNext() {
        onAddAdGroupsMobileContentPage().clickNext();
        sleep(1000);
    }

    @Step("Раскрываем настройки группы: {0}")
    public void clickOnOpenGroupSettings(Long groupId) {
        onAddAdGroupsMobileContentPage().getGroupBlock(groupId).clickOnGroupPropertiesIfNotOpened();
    }

    @Step("Нажимаем вперед и проверяем, что перешли на другую страницу")
    public void goNextAndCheckNextPageURL() {
        String currentURL = config.getDriver().getCurrentUrl();
        onAddAdGroupsMobileContentPage().clickNext();
        getCommonSteps().shouldSeeBrowser(not(hasURL(equalTo(currentURL))));
    }

    @Step("Нажимаем вперед и проверяем, что алерт удовлетворяет условию {0}")
    public void goNextWithAlert(Matcher<String> matcher) {
        onAddAdGroupsMobileContentPage().clickNext();
        AlertSteps.getInstance(AlertSteps.class, config).accept(matcher);
    }

    @Step("Нажимаем вперед и ок в алерте")
    public void goNextWithAlertOk() {
        onAddAdGroupsMobileContentPage().clickNext();
        AlertSteps.getInstance(AlertSteps.class, config).acceptIfPresent();
    }

    @Step("Нажимаем ок в алерте")
    public void alertOk() {
        AlertSteps.getInstance(AlertSteps.class, config).acceptIfPresent();
    }

    public void addNewBannerListForExistingGroup(List<MobileAppBannerInfoWeb> mobileAppBannerInfoList) {
        for (MobileAppBannerInfoWeb mobileAppBannerInfo : mobileAppBannerInfoList) {
            clickAddNewBanner();
            fillBannerParameters(wrap(mobileAppBannerInfo));
        }
    }

    public void addNewBannerListForNewGroup(List<MobileAppBannerInfoWeb> mobileAppBannerInfoList) {
        for (int i = 0; i < mobileAppBannerInfoList.size(); i++) {
            if (i != 0) {
                clickAddNewBanner();
            }
            fillBannerParameters(wrap(mobileAppBannerInfoList.get(i)));
        }
    }

    @Step("Нажимаем кнопку Добавить мобильное объявление")
    public void clickAddNewBanner() {
        onAddAdGroupsMobileContentPage().clickAddNewBanner();
    }

    @Step("Заполняем параметры мобильного баннера")
    public void fillBannerParameters(IBeanWrapper<MobileAppBannerInfoWeb> banner) {
        AllureUtils.addJsonAttachment("Параметры баннера мобильных приложений", banner.toString());
        MobileAppBannerInfoWeb mobileAppBannerInfo = banner.getBean();
        addAdGroupsMobileContentPageForParameters(mobileAppBannerInfo.getBannerId(),
                mobileAppBannerInfo.getAdGroupID());
        onAddAdGroupsMobileContentPage().fillBannerParameters(mobileAppBannerInfo);
    }

    @Step("Заполняем параметры гео для группы")
    public void fillRegions(IBeanWrapper<MobileAppBannerInfoWeb> banner) {
        AllureUtils.addJsonAttachment("Параметры баннера мобильных приложений", banner.toString());
        MobileAppBannerInfoWeb mobileAppBannerInfo = banner.getBean();
        addAdGroupsMobileContentPageForParameters(mobileAppBannerInfo.getBannerId(),
                mobileAppBannerInfo.getAdGroupID());
        onAddAdGroupsMobileContentPage().fillRegions(mobileAppBannerInfo);
    }

    @Step("Заполняем минус фразы группы")
    public void fillGroupMinusKeywords(IBeanWrapper<MobileAppBannerInfoWeb> banner) {
        MobileAppBannerInfoWeb mobileAppBannerInfo = banner.getBean();
        addAdGroupsMobileContentPageForParameters(mobileAppBannerInfo.getBannerId(),
                mobileAppBannerInfo.getAdGroupID());
        onAddAdGroupsMobileContentPage().fillGroupMinusKeywords(mobileAppBannerInfo);
    }

    @Step("Заполняем максимальную ставку для условий показа")
    public void fillGroupMaxPrice(Long groupId, Float maxPrice) {
        onAddAdGroupsMobileContentPage().fillMaxPrice(groupId, maxPrice);
    }

    @Step("Редактируем фразу")
    public void editPhraseText(IBeanWrapper<OptimizedPhraseInfoWeb> phrase, String newPhraseText) {
        AllureUtils.addJsonAttachment("Ищем фразу", phrase.toString());
        AllureUtils.addTextAttachment("Новый текст фразы", newPhraseText);
        OptimizedPhraseInfoWeb phraseInfoWeb = phrase.getBean();
        addAdGroupsMobileContentPageForParameters(phraseInfoWeb.getBannerId(),
                phraseInfoWeb.getAdGroupID());
        onAddAdGroupsMobileContentPage().editPhraseText(phraseInfoWeb, newPhraseText);
    }

    @Step("Нажимаем на кнопку 'Уточнить' для фразы {0}")
    public void clickRefinePhrase(IBeanWrapper<BannerPhraseInfoWeb> phrase) {
        addAdGroupsMobileContentPageForParameters(phrase.getBean().getBannerId(),
                phrase.getBean().getAdGroupID());
        onAddAdGroupsMobileContentPage().clickRefinePhraseButton(phrase.getBean().getPhrase());
    }

    @Step("Проверяем параметры баннера")
    public void shouldSeeBannerParameters(IBeanWrapper<MobileAppBannerInfoWeb> bannerInfo) {
        AllureUtils.addJsonAttachment("Параметры баннера", bannerInfo.toString());
        MobileAppBannerInfoWeb expectedBanner = bannerInfo.getBean();
        addAdGroupsMobileContentPageForParameters(expectedBanner.getBannerId(),
                expectedBanner.getAdGroupID());
        onAddAdGroupsMobileContentPage().checkBannerParameters(expectedBanner);
    }

    @Step("Проверяем параметры баннера")
    public void shouldSeeBannerParameters(Long adgroupId, Long bannerId,
            IBeanWrapper<MobileAppBannerInfoWeb> bannerInfo)
    {
        AllureUtils.addJsonAttachment("Параметры баннера", bannerInfo.toString());
        MobileAppBannerInfoWeb expectedBanner = bannerInfo.getBean();
        addAdGroupsMobileContentPageForParameters(bannerId, adgroupId);
        onAddAdGroupsMobileContentPage().checkBannerParameters(expectedBanner);
    }

    @Step("Проверяем параметры превью баннера")
    public void shouldSeeBannerPreviewParameters(IBeanWrapper<MobileAppBannerInfoWeb> bannerInfo) {
        AllureUtils.addJsonAttachment("Параметры баннера", bannerInfo.toString());
        MobileAppBannerInfoWeb expectedBanner = bannerInfo.getBean();
        addAdGroupsMobileContentPageForParameters(expectedBanner.getBannerId(),
                expectedBanner.getAdGroupID());
        onAddAdGroupsMobileContentPage().checkMobileAppBannerPreviewParameters(expectedBanner);
    }

    public void shouldSeeBannerListParameters(List<MobileAppBannerInfoWeb> bannerInfoList) {
        bannerInfoList.forEach(t -> shouldSeeBannerParameters(wrap(t)));
    }

    public void shouldSeeArchiveExistWarningMessage() {
        onAddAdGroupsMobileContentPage().checkErrorTextPresent(BannersGroupErrorResource.ARCHIVE_BANNERS_EXIST);
    }


    @Step("Проверяем кол-во банноров на странице равное {1}")
    public void shouldSeeCountBanners(Long adGroupID, int count) {
        onAddAdGroupsMobileContentPage().forAdGroupId(adGroupID);
        onAddAdGroupsMobileContentPage().checkBannersCount(count);
    }

    @Step("Проверяем, что список минус слов для баннера {0} удовлетворяет условию {1}")
    public void shouldSeeMinusKeywordsForPhrases(Long bannerId, Matcher matcher) {
        addAdGroupsMobileContentPageForParameters(bannerId);
        onAddAdGroupsMobileContentPage().checkBannerPhraseList(matcher);
    }

    @Step("Применяем групповые изменения для мобильных баннеров")
    public void applyGroupChanges(IBeanWrapper<MobileGroupChangesInfo> mobileGroupChangesInfo) {
        AllureUtils.addJsonAttachment("Параметры групповых изменений", mobileGroupChangesInfo.toString());
        onAddAdGroupsMobileContentPage().fillGroupEditParameters(mobileGroupChangesInfo.getBean());
    }

    @Step("Открываем вкладку {0} на попапе групповых изменений")
    public void openGroupChangesTab(IBeanWrapper<MobileGroupChangesBlockTabs> mobileGroupChangesBlockTabs) {
        onAddAdGroupsMobileContentPage().openGroupChangesTab(mobileGroupChangesBlockTabs.getBean());
    }

    @Step("Добавляем условие ретаргетинга")
    public void addRetargetingCondition(IBeanWrapper<RetargetingConditionWeb> conditionWeb) {
        AllureUtils.addJsonAttachment("Параметры условия", conditionWeb.toString());
        addAdGroupsMobileContentPageForParameters(conditionWeb.getBean().getBannerId(),
                conditionWeb.getBean().getAdGroupId());
        onAddAdGroupsMobileContentPage().addRetargetingCondition(conditionWeb.getBean());
    }

    @Step("Редактируем условие ретаргетинга")
    public void editRetargetingCondition(IBeanWrapper<RetargetingConditionWeb> conditionWeb) {
        AllureUtils.addJsonAttachment("Параметры условия", conditionWeb.toString());
        addAdGroupsMobileContentPageForParameters(conditionWeb.getBean().getBannerId(),
                conditionWeb.getBean().getAdGroupId());
        onAddAdGroupsMobileContentPage().editRetargetingCondition(conditionWeb.getBean());
    }

    @Step("Редактируем сохраненное условие ретаргетинга {0}")
    public void editSavedRetargetingCondition(String conditionName,
            IBeanWrapper<RetargetingConditionWeb> conditionWeb)
    {
        AllureUtils.addJsonAttachment("Новые параметры условия", conditionWeb.toString());
        addAdGroupsMobileContentPageForParameters(conditionWeb.getBean().getBannerId(),
                conditionWeb.getBean().getAdGroupId());
        onAddAdGroupsMobileContentPage().editSavedRetargetingCondition(conditionName, conditionWeb.getBean());
    }

    @Step("Удаляем условие ретаргетинга {1} из баннера {0}")
    public void deleteRetargetingCondition(Long bannerId, String conditionName) {
        addAdGroupsMobileContentPageForParameters(bannerId);
        onAddAdGroupsMobileContentPage().deleteRetargetingCondition(conditionName);
    }

    @Step("Проверяем параметры условия ретаргетинга")
    public void shouldSeeRetargetingConditionParameters(IBeanWrapper<RetargetingConditionWeb> conditionWeb) {
        addAdGroupsMobileContentPageForParameters(conditionWeb.getBean().getBannerId(),
                conditionWeb.getBean().getAdGroupId());
        onAddAdGroupsMobileContentPage().checkRetargetingConditionParameters(conditionWeb.getBean());
    }

    @Step("Проверяем параметры корректировки ставок")
    public void shouldSeeHierarchicalMultipliersParameters(
            IBeanWrapper<HierarchicalMultipliersWeb> hierarchicalMultipliers,
            Long bannerId, Long adGroupId)
    {
        addAdGroupsMobileContentPageForParameters(bannerId, adGroupId);
        onAddAdGroupsMobileContentPage().checkHierarchicalMultipliersParameters(hierarchicalMultipliers.getBean());
    }

    @Step("Проверяем, что список параметров условий ретаргетинга удовлетворяет условию {0}")
    public void shouldSeeRetargetingConditionList(Matcher matcher) {
        onAddAdGroupsMobileContentPage().checkRetargetingConditionsList(matcher);
    }

    @Step("Выбор типа отображаемого превью для баннера")
    public void chooseBannerPreviewType(Long adgroupId, Long bannerId, BannerPreviewType type) {
        onAddAdGroupsMobileContentPage().choosePreviewTypeForBanner(adgroupId, bannerId, type);
    }

    @Step("Добавляем картинку в баннер {0} используя метод {1}")
    public void fillImageAndSave(Long bannerId, ImageLoadType type, String img) {
        addAdGroupsMobileContentPageForParameters(bannerId);
        onAddAdGroupsMobileContentPage().fillImageAndSave(type, img);
    }

    @Step("Проверяем, что атрибут src картинки в баннере {0} удовлетворяет условию {1}")
    public void shouldSeeImageSrc(Long bannerId, Matcher<String> matcher) {
        addAdGroupsMobileContentPageForParameters(bannerId);
        onAddAdGroupsMobileContentPage().checkImage(allOf(exists(),
                hasAttribute("src", matcher)));
    }

    //----------------------------------------------------------
    @Step("Открыть массовые изменения")
    public void openMassActionsPopup() {
        onAddAdGroupsMobileContentPage().clickGroupChangesButton();
    }

    @Step("Открыть попап минус-слов в группе")
    public void openRegionsPopupInGroup(Long adgroupId) {
        onAddAdGroupsMobileContentPage().openRegionsPopupInGroup(adgroupId);
    }

    @Step("Открыть попап минус-слов в группе")
    public void openRetargetingPopupInGroup(Long adgroupId) {
        onAddAdGroupsMobileContentPage().openRetargetingPopupInGroup(adgroupId);
    }

    @Step("Открыть попап минус-слов в группе")
    public void openAdjustmentRatesPopupInGroup(Long adgroupId) {
        onAddAdGroupsMobileContentPage().openAdjustmentRatesPopupInGroup(adgroupId);
    }

    @Step("Открыть попап минус-слов в группе")
    public void openMinusWordsPopupInGroup(Long adgroupId) {
        onAddAdGroupsMobileContentPage().openMinusWordsPopupInGroup(adgroupId);
    }

    @Step("Открыть попап изображения в объявлении")
    public void openImagePopupInBanner(Long adgroupId, Long bannerId) {
        onAddAdGroupsMobileContentPage().openImagePopupInBanner(adgroupId, bannerId);
    }
}
