package ru.yandex.autotests.direct.web.steps.banners;

import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.web.data.textresources.Strings;
import ru.yandex.autotests.direct.web.objects.banners.BannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.OptimizedPhraseInfoWeb;
import ru.yandex.autotests.direct.web.objects.retargeting.RetargetingConditionWeb;
import ru.yandex.autotests.direct.web.pages.banners.AddBannerMultiEditPage;
import ru.yandex.autotests.direct.web.steps.BackendSteps;
import ru.yandex.autotests.direct.web.steps.UserSteps;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;
import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.core.StringStartsWith.startsWith;
import static ru.yandex.qatools.htmlelements.matchers.WebElementMatchers.exists;
import static ru.yandex.qatools.htmlelements.matchers.WebElementMatchers.hasAttribute;

public class AddBannerMultiEditPageSteps extends BaseSteps {

    private AddBannerMultiEditPage onAddBannerMultiEditPage() {
        return AddBannerMultiEditPage.getInstance(AddBannerMultiEditPage.class, config);
    }

    private void addBannerMultiEditPageForParameters(Long bannerId) {
        addBannerMultiEditPageForParameters(bannerId, null);
    }

    private void addBannerMultiEditPageForParameters(Long bannerId, Long adGroupID) {
        onAddBannerMultiEditPage().forBannerId(bannerId);
        if (adGroupID == null) {
            if (bannerId == null || bannerId.equals(0L)) {
                adGroupID = 0L;
            } else {
                adGroupID = new BackendSteps().getAdGroupIdByBannerId(bannerId);
            }
        }
        onAddBannerMultiEditPage().forAdGroupId(adGroupID);
    }

    @Step("Нажимаем назад")
    public void goBack() {
        onAddBannerMultiEditPage().clickBack();
    }

    @Step("Нажимаем вперед и проверяем, что произошел переход на страницу кампании")
    public void goNextAndWaitCampPage() {
        onAddBannerMultiEditPage().clickNext();
        getDirectWebUserSteps().inOperatingSystem().
                waitForPageTitle(startsWith(Strings.TITLE_CAMPAIGN_VIEW));
    }

    private UserSteps getDirectWebUserSteps() {
        return getInstance(UserSteps.class, config);
    }

    @Step("Заполняем параметры баннера")
    public void fillBannerParameters(IBeanWrapper<BannerInfoWeb> banner) {
        AllureUtils.addJsonAttachment("Параметры баннера", banner.toString());
        BannerInfoWeb bannerInfo = banner.getBean();
        addBannerMultiEditPageForParameters(bannerInfo.getBannerId(),
                bannerInfo.getAdGroupID());
        onAddBannerMultiEditPage().fillBannerParameters(bannerInfo);
    }

    @Step("Заполняем параметры гео для группы")
    public void fillRegions(IBeanWrapper<BannerInfoWeb> banner) {
        AllureUtils.addJsonAttachment("Параметры баннера", banner.toString());
        BannerInfoWeb bannerInfo = banner.getBean();
        addBannerMultiEditPageForParameters(bannerInfo.getBannerId(), bannerInfo.getAdGroupID());
        onAddBannerMultiEditPage().fillRegions(bannerInfo);
    }

    @Step("Редактируем фразу")
    public void editPhraseText(IBeanWrapper<OptimizedPhraseInfoWeb> phrase, String newPhraseText) {
        AllureUtils.addJsonAttachment("Ищем фразу", phrase.toString());
        AllureUtils.addTextAttachment("Новый текст фразы", newPhraseText);
        OptimizedPhraseInfoWeb phraseInfoWeb = phrase.getBean();
        addBannerMultiEditPageForParameters(phraseInfoWeb.getBannerId(),
                phraseInfoWeb.getAdGroupID());
        onAddBannerMultiEditPage().editPhraseText(phraseInfoWeb, newPhraseText);
    }

    @Step("Проверяем параметры баннера")
    public void shouldSeeBannerParameters(IBeanWrapper<BannerInfoWeb> bannerInfo) {
        AllureUtils.addJsonAttachment("Параметры баннера", bannerInfo.toString());
        BannerInfoWeb expectedBanner = bannerInfo.getBean();
        expectedBanner.setStatusShow(null); //todo выпилить StatusShow из BannerInfoWeb
        addBannerMultiEditPageForParameters(expectedBanner.getBannerId(),
                expectedBanner.getAdGroupID());
        onAddBannerMultiEditPage().checkBannerParameters(expectedBanner);
    }

    @Step("Проверяем параметры баннера")
    public void shouldSeeBannerParameters(Long adgroupId, Long bannerId, IBeanWrapper<BannerInfoWeb> bannerInfo) {
        AllureUtils.addJsonAttachment("Параметры баннера", bannerInfo.toString());
        BannerInfoWeb expectedBanner = bannerInfo.getBean();
        addBannerMultiEditPageForParameters(bannerId, adgroupId);
        onAddBannerMultiEditPage().checkBannerParameters(expectedBanner);
    }

    @Step("Добавляем сохраненное условие ретаргетинга {1} в баннер {0}")
    public void addSavedRetargetingCondition(Long bannerId, String conditionName) {
        addBannerMultiEditPageForParameters(bannerId);
        onAddBannerMultiEditPage().addSavedRetargetingCondition(conditionName);
    }

    @Step("Удаляем условие ретаргетинга {1} из баннера {0}")
    public void deleteRetargetingCondition(Long bannerId, String conditionName) {
        addBannerMultiEditPageForParameters(bannerId);
        onAddBannerMultiEditPage().deleteRetargetingCondition(conditionName);
    }

    @Step("Проверяем параметры условия ретаргетинга")
    public void shouldSeeRetargetingConditionParameters(IBeanWrapper<RetargetingConditionWeb> conditionWeb) {
        addBannerMultiEditPageForParameters(conditionWeb.getBean().getBannerId(),
                conditionWeb.getBean().getAdGroupId());
        onAddBannerMultiEditPage().checkRetargetingConditionParameters(conditionWeb.getBean());
    }

    @Step("Проверяем, что атрибут src картинки в баннере {0} удовлетворяет условию {1}")
    public void shouldSeeImageSrc(Long bannerId, Matcher<String> matcher) {
        addBannerMultiEditPageForParameters(bannerId);
        onAddBannerMultiEditPage().checkImage(allOf(exists(),
                hasAttribute("src", matcher)));
    }
}
