package ru.yandex.autotests.direct.web.steps.banners;

import java.util.List;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.web.data.BannerPreviewType;
import ru.yandex.autotests.direct.web.objects.banners.BaseBannerWeb;
import ru.yandex.autotests.direct.web.objects.groups.BaseGroupWeb;
import ru.yandex.autotests.direct.web.pages.banners.AddAdGroupsDynamicPage;
import ru.yandex.autotests.direct.web.pages.banners.AddAdGroupsPerformancePage;
import ru.yandex.autotests.direct.web.pages.banners.BaseGroupPage;
import ru.yandex.autotests.direct.web.steps.AlertSteps;
import ru.yandex.autotests.direct.web.steps.BackendSteps;
import ru.yandex.autotests.direct.web.steps.CommonSteps;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.Matchers.equalToIgnoringCase;
import static ru.yandex.autotests.direct.web.util.matchers.webdriver.HasURL.hasURL;

/**
 * Created by aleran on 24.11.2015.
 */
public class AddGroupPageSteps extends BaseSteps {

    private BaseGroupPage groupPage;

    public CommonSteps getCommonSteps() {
        return CommonSteps.getInstance(CommonSteps.class, config);
    }

    @Step("Устанавливаем текущую группу")
    public void setGroupPage(BaseGroupPage groupPage) {
        this.groupPage = groupPage;
    }

    private BaseGroupPage onGroupPage() {
        return groupPage;
    }

    private void addAdGroupsPageForParameters(Long adGroupId) {
        addAdGroupsPageForParameters(null, adGroupId);
    }

    private void addAdGroupsPageForParameters(Long bannerId, Long adGroupID) {
        onGroupPage().forBannerId(bannerId);
        if (adGroupID == null) {
            if (bannerId == null || bannerId.equals(0L)) {
                adGroupID = 0L;
            } else {
                adGroupID = new BackendSteps().getAdGroupIdByBannerId(bannerId);
            }
        }
        onGroupPage().forAdGroupId(adGroupID);
    }

    @Step("Нажимаем назад")
    public void goBack() {
        onGroupPage().clickBack();
    }

    @Step("Нажимаем вперед")
    public void goNext() {
        onGroupPage().clickNext();
    }

    @Step("Нажимаем вперед")
    public void saveGroup() {
        String currentURL = config.getDriver().getCurrentUrl();
        onGroupPage().clickSaveGroup();
        getCommonSteps().shouldSeeBrowser(CoreMatchers.not(hasURL(equalToIgnoringCase(currentURL))));
    }

    @Step("Нажимаем вперед и проверяем, что перешли на другую страницу")
    public void goNextAndCheckNextPageURL() {
        String currentURL = config.getDriver().getCurrentUrl();
        onGroupPage().clickNext();
        getCommonSteps().shouldSeeBrowser(not(hasURL(equalTo(currentURL))));
    }

    @Step("Нажимаем вперед и проверяем, что алерт удовлетворяет условию {0}")
    public void goNextWithAlert(Matcher<String> matcher) {
        onGroupPage().clickNext();
        AlertSteps.getInstance(AlertSteps.class, config).accept(matcher);
    }

    @Step("Нажимаем вперед и ок в алерте")
    public void goNextWithAlertOk() {
        onGroupPage().clickNext();
        AlertSteps.getInstance(AlertSteps.class, config).acceptIfPresent();
    }

    @Step("Нажимаем ок в алерте")
    public void alertOk() {
        AlertSteps.getInstance(AlertSteps.class, config).acceptIfPresent();
    }

    @Step("Заполняем параметры группы")
    public void fillGroupParameters(BaseGroupWeb group) {
        AllureUtils.addJsonAttachment("Параметры группы", group.toString());
        addAdGroupsPageForParameters(group.getAdGroupId());
        onGroupPage().fillGroupParameters(group);
    }

    @Step("Заполняем параметры гео для группы")
    public void fillRegions(BaseGroupWeb group) {
        AllureUtils.addJsonAttachment("Параметры группы", group.toString());
        addAdGroupsPageForParameters(group.getAdGroupId());
        onGroupPage().fillRegions(group);
    }

    @Step("Заполняем параметры баннера")
    public void fillBannerParameters(BaseBannerWeb banner) {
        AllureUtils.addJsonAttachment("Параметры баннера", banner.toString());
        addAdGroupsPageForParameters(banner.getBannerId(), banner.getAdGroupId());
        onGroupPage().fillBannerParameters(banner);
    }

    @Step("Проверяем параметры группы")
    public void shouldSeeGroupParameters(BaseGroupWeb group) {
        AllureUtils.addJsonAttachment("Параметры группы", group.toString());
        addAdGroupsPageForParameters(group.getAdGroupId());
        onGroupPage().checkGroupParameters(group);
    }

    @Step("Проверяем параметры баннера")
    public void shouldSeeBannerParameters(BaseBannerWeb banner) {
        AllureUtils.addJsonAttachment("Параметры баннера", banner.toString());
        addAdGroupsPageForParameters(banner.getBannerId(),
                banner.getAdGroupId());
        onGroupPage().checkBannerParameters(banner);
    }

    @Step("Проверяем параметры корректировки ставок")
    public void shouldSeeHierarchicalMultipliersParameters(BaseGroupWeb group)
    {
        addAdGroupsPageForParameters(group.getAdGroupId());
        onGroupPage().checkHierarchicalMultipliersParameters(group);
    }

    public void shouldSeeBannerListParameters(List<BaseBannerWeb> bannerList) {
        bannerList.forEach(this::shouldSeeBannerParameters);
    }

    @Step("Проверяем кол-во баннeров на странице равное {1}")
    public void shouldSeeCountBanners(Long adGroupID, int count) {
        onGroupPage().forAdGroupId(adGroupID);
        onGroupPage().checkBannersCount(count);
    }

    @Step("Работаем с мобильными группами")
    public void workWithMobileAppPage() {
//        groupPage = BasePageObject.getInstance(AddAdGroupsMobileContentPage.class, config);
    }

    @Step("Работаем с ДМО")
    public void workWithPerformancePage() {
        groupPage = BasePageObject.getInstance(AddAdGroupsPerformancePage.class, config);
    }

    @Step("Работаем с ДТО")
    public void workWithDynamicTextPage() {
        groupPage = BasePageObject.getInstance(AddAdGroupsDynamicPage.class, config);
    }

    @Step("Нажимаем 'Добавить объявление'")
    public void clickAddNewBanner() {
        onGroupPage().clickAddNewBannerButton();
    }

    @Step("Выбор типа превью объявления")
    public void chooseBannerPreviewType(Long adgroupId, Long bannerId, BannerPreviewType previewType) {
        onGroupPage().chooseBannerPreviewType(adgroupId, bannerId, previewType);
    }

    @Step("Открыть попап минус-слов на группу")
    public void openMinusWordsPopupInGroup(Long adgroupId) {
        onGroupPage().openMinusWordsPopup(adgroupId);
    }

    @Step("Открыть попап регионов показа на группу")
    public void openRegionsPopupInGroup(Long adgroupId) {
        onGroupPage().openRegionsPopup(adgroupId);
    }

    @Step("Открыть попап корректировок ставок на группу")
    public void openAdjustmentRatesPopupInGroup(Long adgroupId) {
        onGroupPage().openAdjustmentRatesPopup(adgroupId);
    }

    @Step("Открыть попап быстрых ссылок в объявлении")
    public void openSiteLinksPopupInBanner(Long adgroupId, Long bannerId) {
        onGroupPage().openSiteLinksPopupInBanner(adgroupId, bannerId);
    }

    @Step("Открыть попап уточнений в объявлении")
    public void openCalloutsPopupInBanner(Long adgroupId, Long bannerId) {
        onGroupPage().openCalloutsPopupInBanner(adgroupId, bannerId);
    }

    @Step("Открыть попап редактирования фильтра")
    public void openEditFilterPopupInGroup(Long adgroupId, String filterName) {
        onGroupPage().openEditFilterPopup(adgroupId, filterName);
    }

    public AddAdGroupsPerformancePage getPerformanceGroupPage() {
        return (AddAdGroupsPerformancePage) onGroupPage();
    }
}
