package ru.yandex.autotests.direct.web.steps.banners;

import org.hamcrest.Matcher;
import org.openqa.selenium.internal.WrapsElement;

import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.direct.web.data.priceconstructor.BannerPhrasePlatform;
import ru.yandex.autotests.direct.web.objects.banners.BannerPhraseInfoWeb;
import ru.yandex.autotests.direct.web.objects.retargeting.RetargetingConditionWeb;
import ru.yandex.autotests.direct.web.pages.banners.blocks.phrases.BannerPhraseRowBlock;
import ru.yandex.autotests.direct.web.pages.showcampbem.IBannerPhrasesListProvider;
import ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners.phrases.BannerPhraseRowBlockBEM;
import ru.yandex.autotests.direct.web.pages.showcampbem.blocks.banners.phrases.BannerPhrasesBlockBEM;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import static org.hamcrest.core.IsEqual.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class BannerPhrasesBlockBemSteps extends BaseSteps {
    private IBannerPhrasesListProvider pageWithPhrases;

    protected BannerPhrasesBlockBEM onPageWithBannerPhrases() {
        if (pageWithPhrases == null) {
            throw new DirectWebError("Перед выполнением операции укажите страницу степом forPage()");
        } else {
            return pageWithPhrases.getBannerPhrasesBlock();
        }
    }

    public PhraseRefineBlockSteps onPhraseRefineBlock() {
        return getInstance(PhraseRefineBlockSteps.class, config, this);
    }

    public void forPage(IBannerPhrasesListProvider pageWithPhrases) {
        this.pageWithPhrases = pageWithPhrases;
    }

    @Step("Заполняем параметры фразы на {0}")
    public void fillPhraseParameters(BannerPhrasePlatform platform, IBeanWrapper<BannerPhraseInfoWeb> phrase) {
        AllureUtils.addJsonAttachment("Параметры фразы", phrase.toString());
        onPageWithBannerPhrases().fillPhraseParameters(phrase.getBean(), platform);
    }

    @Step("Изменяем текст фразы на платформе {0} на {2}")
    public void changePhraseText(BannerPhrasePlatform platform, IBeanWrapper<BannerPhraseInfoWeb> phrase, String text) {
        onPageWithBannerPhrases().changePhraseText(phrase.getBean(), platform, text);
    }


    @Step("Восстанавливаем фразу {1}")
    public void restorePhrase(BannerPhrasePlatform platform, BannerPhraseInfoWeb phraseInfo) {
        onPageWithBannerPhrases().restorePhrase(platform, phraseInfo);
    }

    @Step("Удаляем условие ретаргетинга {1}")
    public void deleteRetargetingCondition(BannerPhrasePlatform platform, RetargetingConditionWeb conditionWeb) {
        onPageWithBannerPhrases().deleteRetargetingCondition(platform, conditionWeb);
    }

    @Step("Удаляем фразу {1}")
    public void deletePhrase(BannerPhrasePlatform platform, BannerPhraseInfoWeb phraseInfo) {
        onPageWithBannerPhrases().deletePhrase(platform, phraseInfo);
    }

    @Step("Нажимаем кнопку 'Уточнить' для фразы {1}")
    public void refinePhrase(BannerPhrasePlatform platform, BannerPhraseInfoWeb phraseInfo) {
        onPageWithBannerPhrases().clickRefinePhrase(platform, phraseInfo);
    }

    @Step("Заполняем параметры условия ретаргетинга")
    public void fillRetargetingParameters(BannerPhrasePlatform platform,
            IBeanWrapper<RetargetingConditionWeb> retargeting)
    {
        AllureUtils.addJsonAttachment("Параметры условия", retargeting.toString());
        onPageWithBannerPhrases().fillRetargetingConditionParameters(retargeting.getBean(), platform);
    }

    @Step("Проверяем параметры фразы на {0}")
    public void shouldSeePhrase(BannerPhrasePlatform platform, BeanEquals<BannerPhraseInfoWeb> matcher) {
        AllureUtils.addJsonAttachment("Параметры фразы должны", matcher.toString());
        onPageWithBannerPhrases().checkPhraseParameters(platform, matcher);
    }

    @Step("Проверяем, что цена фразы на {1} удовлетворяет условию {2}")
    public void shouldSeePhrasePrice(IBeanWrapper<BannerPhraseInfoWeb> phraseInfo, BannerPhrasePlatform platform,
            Matcher<WrapsElement> matcher)
    {
        AllureUtils.addJsonAttachment("Параметры фразы", phraseInfo.toString());
        onPageWithBannerPhrases().checkPhrasePrice(phraseInfo.getBean(), platform, matcher);
    }

    @Step("Проверяем, что фраза на {0} удовлетворяет условию {2}")
    public void shouldSeePhraseRow(BannerPhrasePlatform platform, IBeanWrapper<BannerPhraseInfoWeb> phraseInfo,
            Matcher matcher)
    {
        AllureUtils.addJsonAttachment("Параметры фразы", phraseInfo.toString());
        onPageWithBannerPhrases().checkPhraseRowBlock(platform, phraseInfo.getBean(), matcher);
    }

    @Step("Получаем параметры фразы на {1} с формы")
    public BannerPhraseInfoWeb getPhraseParameters(IBeanWrapper<BannerPhraseInfoWeb> expectedPhrase,
            BannerPhrasePlatform platform)
    {
        BannerPhraseInfoWeb phraseInfo = onPageWithBannerPhrases().getPhaseInfo(expectedPhrase.getBean(), platform);
        AllureUtils.addJsonAttachment("Параметры фразы", phraseInfo.toString());
        return phraseInfo;
    }

    @Step("Проверяем параметры условия ретаргетинга")
    public void shouldSeeCondition(BeanEquals<RetargetingConditionWeb> matcher, BannerPhrasePlatform platform) {
        AllureUtils.addJsonAttachment("Параметры условия должны", matcher.toString());
        onPageWithBannerPhrases().checkRetargetingCondition(matcher, platform);
    }

    @Step("Проверяем, что все минус-слова фразы из баннера {0} на {1} удовлетворяют условию {2}")
    public void shouldSeeMinusKeywordsOnPhrases(Long bannerId, BannerPhrasePlatform platform, Matcher matcher) {
        AllureUtils.addJsonAttachment("Параметры фразы", matcher.toString());
        onPageWithBannerPhrases().checkPhrasesMinusKeyWordPopupText(bannerId, platform, matcher);
    }

    @Step("Устанавливаем цену на все объявление")
    public void setPriceForAllPhrasesInGroup(String price) {
        onPageWithBannerPhrases().setPriceForALlPhrasesInGroup(price);
    }

    @Step("Устанавливаем в группе {0} цену на Соц.Дем {1} ")
    public void setSocDemPriceForAdGroupID(Long adGroupID, Float price) {
        BannerPhraseRowBlockBEM phraseRowBlock = onPageWithBannerPhrases().getSocDemRow(adGroupID);
        phraseRowBlock.setConfig(config);
        phraseRowBlock.fillPrice(price);
    }

    @Step("Проверяем в группе {0} цену на Соц.Дем {1} ")
    public void shouldSeeSocDemPriceForAdGroupID(Long adGroupID, Float price) {
        Float actualPrice = onPageWithBannerPhrases().getSocDemRow(adGroupID).getPrice();
        assertThat("цена соответствует ожиданию", actualPrice, equalTo(price));
    }

}