package ru.yandex.autotests.direct.web.steps.banners;

import org.hamcrest.Matcher;
import org.openqa.selenium.internal.WrapsElement;

import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.utils.matchers.BeanCompareStrategy;
import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.direct.web.data.priceconstructor.BannerPhrasePlatform;
import ru.yandex.autotests.direct.web.objects.banners.BannerPhraseInfoWeb;
import ru.yandex.autotests.direct.web.objects.retargeting.RetargetingConditionWeb;
import ru.yandex.autotests.direct.web.pages.banners.blocks.phrases.BannerPhrasesBlock;
import ru.yandex.autotests.direct.web.pages.banners.blocks.phrases.BannerPhrasesPage;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.direct.utils.beans.BeanWrapper.wrap;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class BannerPhrasesBlockSteps extends BaseSteps {

    protected BannerPhrasesBlock onPageWithBannerPhrases() {
        return BannerPhrasesPage.getInstance(BannerPhrasesPage.class, config).getBannerPhrasesBlock();
    }

    @Step("Заполняем параметры фразы на {1}")
    public void fillPhraseParameters(IBeanWrapper<BannerPhraseInfoWeb> phrase, BannerPhrasePlatform platform) {
        AllureUtils.addJsonAttachment("Параметры фразы", phrase.toString());
        onPageWithBannerPhrases().fillPhraseParameters(phrase.getBean(), platform);
    }

    @Step("Заполняем параметры условия ретаргетинга")
    public void fillRetargetingParameters(IBeanWrapper<RetargetingConditionWeb> retargeting,
                                          BannerPhrasePlatform platform) {
        AllureUtils.addJsonAttachment("Параметры условия", retargeting.toString());
        onPageWithBannerPhrases().fillRetargetingParameters(retargeting.getBean(), platform);
    }

    @Step("Проверяем параметры фразы на {1}")
    public void shouldSeePhrase(IBeanWrapper<BannerPhraseInfoWeb> phraseInfo, BannerPhrasePlatform platform,
                                BeanCompareStrategy compareStrategy) {
        BeanEquals<BannerPhraseInfoWeb> matcher = beanEquals(phraseInfo.getBean()).accordingStrategy(compareStrategy);
        AllureUtils.addJsonAttachment("Параметры фразы", matcher.toString());
        onPageWithBannerPhrases().checkPhraseParameters(platform, matcher);
    }

    @Step("Проверка отсутствия фразы {1} на {2} в баннере {0}")
    public void shouldNotSeePhrase(Long bannerId, String phraseText, BannerPhrasePlatform platform) {
        onPageWithBannerPhrases().checkBannerPhraseRowBlock(bannerId, phraseText, platform, equalTo(null));
    }

    @Step("Получаем параметры фразы на {1} с формы")
    public BannerPhraseInfoWeb getPhraseParameters(IBeanWrapper<BannerPhraseInfoWeb> expectedPhrase,
                                                   BannerPhrasePlatform platform) {
        BannerPhraseInfoWeb phraseInfo = onPageWithBannerPhrases().getPhraseInfo(expectedPhrase.getBean(), platform);
        AllureUtils.addJsonAttachment("Параметры фразы", wrap(phraseInfo).toString());
        return phraseInfo;
    }

    @Step("Проверяем, что все минус слова для баннера {0} на {1} удовлетворяют условию {2}")
    public void shouldSeeMinusKeywordsOnPhrases(Long bannerId, BannerPhrasePlatform platform, Matcher matcher) {
        onPageWithBannerPhrases().checkPhrasesMinusKeyWordPopupText(bannerId, platform, matcher);
    }

    @Step("Откроняем фразу {1} в баннере {0}")
    public void declinePhrase(Long bannerId, String phraseText) {
        onPageWithBannerPhrases().declinePhrase(bannerId, phraseText);
    }

    @Step("Проверяем сообщение о непринятии клиентом фразы {1} из баннера {0}")
    public void shouldSeeClientDeclineText(Long bannerId, String phraseText) {
        onPageWithBannerPhrases().checkClientDeclinePhrase(bannerId, phraseText);
    }

    @Step("Выбираем фразы {2} на {1} в баннере {0}")
    public void selectPhrasesByText(Long bannerId, BannerPhrasePlatform platform, String... phraseTexts) {
        onPageWithBannerPhrases().selectPhrasesByText(bannerId, platform, phraseTexts);
    }

    @Step("Кликаем показать неактивные фразы")
    public void showInactivePhrases() {
        onPageWithBannerPhrases().showInactive();
    }

    @Step("Проверяем, что цена фразы № {3} на {1} удовлетворяет условию {2}")
    public void shouldSeePhrasePrice(IBeanWrapper<BannerPhraseInfoWeb> expectedPhrase,
                                     BannerPhrasePlatform platform,
                                     Matcher<WrapsElement> matcher,
                                     int index) {
        onPageWithBannerPhrases().checkPhrasePrice(expectedPhrase.getBean(), platform, matcher, index);
    }
}
