package ru.yandex.autotests.direct.web.steps.banners;

import java.util.List;

import ru.yandex.autotests.direct.web.data.textresources.Strings;
import ru.yandex.autotests.direct.web.objects.banners.CpmBannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.groups.CpmGroupInfoWeb;
import ru.yandex.autotests.direct.web.pages.banners.EditGroupsCpmPage;
import ru.yandex.autotests.direct.web.steps.UserSteps;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import static com.google.common.collect.ImmutableList.of;
import static org.hamcrest.core.StringStartsWith.startsWith;
import static ru.yandex.autotests.direct.utils.beans.BeanWrapper.wrap;

public class EditCpmGroupsPageSteps extends BaseSteps {

    public EditGroupsCpmPage onEditGroupsPage() {
        return EditGroupsCpmPage.getInstance(EditGroupsCpmPage.class, config);
    }

    @Step("Заполняем параметры группы")
    public void fillCpmGroup(CpmGroupInfoWeb cpmGroupInfoWeb) {
        fillCpmGroups(of(cpmGroupInfoWeb));
    }

    @Step("Заполняем параметры групп")
    public void fillCpmGroups(List<CpmGroupInfoWeb> cpmGroupInfoWeb) {
        onEditGroupsPage().fillGroups(cpmGroupInfoWeb);
    }

    @Step("Нажимаем 'Сохранить'")
    public void clickSave() {
        onEditGroupsPage().clickSave();
    }

    @Step("Нажимаем 'Сохранить' и ожидаем перехода на следующую страницу")
    public void clickSaveAndExpectSuccess() {
        clickSave();
        UserSteps.getInstance(UserSteps.class, config).inOperatingSystem()
                .waitForPageTitle(startsWith(Strings.TITLE_CAMPAIGN_VIEW));
    }

    @Step("Нажимаем кнопку 'Добавить баннер' в группе id: {0}")
    public void clickAddNewBannerButton(Long adGroupId) {
        onEditGroupsPage().clickOnAddNewBannerButton(adGroupId);
    }

    @Step("Заполняем параметры баннера в группе: {0}")
    public void fillBannerWithId(CpmBannerInfoWeb cpmBannerInfoWeb, Long adGroupId) {
        AllureUtils.addJsonAttachment("Параметры баннера", wrap(cpmBannerInfoWeb).toString());
        onEditGroupsPage().fillBannerWithId(cpmBannerInfoWeb, adGroupId);
    }

    public void checkGroup(CpmGroupInfoWeb cpmGroupInfoWeb) {
        checkGroups(of(cpmGroupInfoWeb));
    }

    @Step("Проверяем параметры групп")
    public void checkGroups(List<CpmGroupInfoWeb> cpmGroupInfoWebs) {
        AllureUtils.addJsonAttachment("группы", wrap(cpmGroupInfoWebs).toString());
        onEditGroupsPage().checkParameters(cpmGroupInfoWebs);
    }
}
