package ru.yandex.autotests.direct.web.steps.banners;

import java.util.List;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;

import ru.yandex.autotests.direct.web.objects.banners.McBannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.groups.McGroupInfoWeb;
import ru.yandex.autotests.direct.web.pages.banners.AddAdGroupsMcBannerPage;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import static com.google.common.collect.ImmutableList.of;
import static ru.yandex.autotests.direct.utils.beans.BeanWrapper.wrap;

public class EditMcGroupPageSteps extends BaseSteps {

    private AddAdGroupsMcBannerPage onEditPage() {
        return AddAdGroupsMcBannerPage.getInstance(AddAdGroupsMcBannerPage.class, config);
    }

    @Step("Кликаем на кнопку 'Дальше' и ожидаем успешный переход")
    public void clickNextAndExpectSuccess() {
        onEditPage().clickNextAndExpectSuccess();
    }

    @Step("Кликаем на кнопку 'Далее'")
    public void clickNext() {
        onEditPage().clickNext();
    }

    @Step("Ожидаем пока кнопка 'Далее' будет активной")
    public void waitUntilNextButtonWillBe(Matcher<WebElement> matcher) {
        onEditPage().waitUntilNextButtonWillBeEnabled(matcher);
    }

    public void fillGroup(McGroupInfoWeb groupInfo) {
        fillGroups(of(groupInfo));
    }

    @Step("Заполняем параметры групп")
    public void fillGroups(List<McGroupInfoWeb> groupsInfo) {
        AllureUtils.addJsonAttachment("Параметры групп", wrap(groupsInfo).toString());
        onEditPage().fillGroups(groupsInfo);
    }

    public void checkGroup(McGroupInfoWeb groupInfoWeb) {
        checkGroup(of(groupInfoWeb));
    }

    @Step("Проверяем что параметры групп соответствуют ожидаемым")
    public void checkGroup(List<McGroupInfoWeb> groupsInfo) {
        AllureUtils.addJsonAttachment("Параметры групп", wrap(groupsInfo).toString());
        onEditPage().checkGroups(groupsInfo);
    }

    @Step("Добавляем баннер в группу {0}")
    public void addBannerToGroup(Long groupId, McBannerInfoWeb bannerInfoWeb) {
        AllureUtils.addJsonAttachment("Параметры баннера", wrap(bannerInfoWeb).toString());
        onEditPage().addBannerToGroup(groupId, bannerInfoWeb);
    }
}