package ru.yandex.autotests.direct.web.steps.banners;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.web.pages.banners.blocks.phrases.PhraseRefineBlock;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;
import ru.yandex.qatools.htmlelements.loader.HtmlElementLoader;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.containsInAnyOrder;

/**
 * Created by shmykov on 28.07.14.
 */
public class PhraseRefineBlockSteps extends BaseSteps {

    protected PhraseRefineBlock onPhraseAdjustblock() {
        return HtmlElementLoader.create(PhraseRefineBlock.class, config.getDriver());
    }

    @Step("Проверяем, что прогнозируемое число показов соответствует {0}")
    public void checkForecastNum(Matcher matcher) {

        assertThat("прогнозируемое число показов не соответствует ожиданиям", onPhraseAdjustblock().getForecastNum(), matcher);
    }

    @Step("Проверяем, что список предложенных минус-слов соответствует условию {0}")
    public void checkMinusWords(Matcher matcher) {
        assertThat("список минус-слов не соответствует ожиданиям", onPhraseAdjustblock().getMinusWordsList(), matcher);
    }

    @Step("Проверяем, что список предложенных минус-слов содержит только уникальные значения")
    public void checkMinusWordsAreDistinctValues() {
        Collection<String> minusWords = onPhraseAdjustblock().getMinusWordsList();
        Collection<String> distinctMinusWords = minusWords.stream().distinct().collect(Collectors.toList());
        assertThat("список минус-слов не соответствует ожиданиям", minusWords,
                containsInAnyOrder(distinctMinusWords.toArray()));
    }

    @Step("Получаем прогнозируемое число показов")
    public Integer getForecastNum() {

        return onPhraseAdjustblock().getForecastNum();
    }

    @Step("Получаем список минус-слов")
    public List<String> getMinusWordsList() {
        return onPhraseAdjustblock().getMinusWordsList();
    }
}