package ru.yandex.autotests.direct.web.steps.banners;

import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.web.objects.banners.SearchBannersInfoWeb;
import ru.yandex.autotests.direct.web.pages.banners.SearchBannersPage;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import static org.hamcrest.MatcherAssert.assertThat;

/**
 * Created by shmykov on 02.07.14.
 */
public class SearchBannersPageSteps extends BaseSteps {

    private SearchBannersPage onSearchBannersPage() {
        return SearchBannersPage.getInstance(SearchBannersPage.class, config);
    }

    @Step("Заполняем поля страницы поиска объявлений и нажимаем 'Найти'")
    public void fillPageFieldsAndSearch(IBeanWrapper<SearchBannersInfoWeb> searchBannersInfoWeb) {
        AllureUtils.addJsonAttachment("Параметры поиска", searchBannersInfoWeb.toString());
        onSearchBannersPage().fillParameters(searchBannersInfoWeb.getBean());
        onSearchBannersPage().clickSearchButton();
    }

    @Step("Проверяем, что список найденных объявлений {0}")
    public void shouldSeeFoundBannersList(Matcher matcher) {
        assertThat("список найденных объявлений не соответствует ожиданиям",
                onSearchBannersPage().getFoundIdsList(), matcher);
    }

    @Step("Проверяем, что список кампаний найденных объявлений {0}")
    public void shouldSeeFoundCampaignsList(Matcher matcher) {
        assertThat("список кампаний найденных объявлений не соответствует ожиданиям",
                onSearchBannersPage().getFoundCampaignIdsList(), matcher);
    }
}
