package ru.yandex.autotests.direct.web.steps.campaigns;

import ru.yandex.autotests.direct.web.pages.campaigns.EditCampaignTagsPage;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

/**
 * @author: Alex Samokhin (alex-samo@yandex-team.ru)
 * Date: 13.01.14
 */
public class EditCampaignTagsPageSteps extends BaseSteps {


    private EditCampaignTagsPage onEditCampaignPage() {
        return EditCampaignTagsPage.getInstance(EditCampaignTagsPage.class, config);
    }

    @Step("Сохраняем новые теги {0}")
    public void saveNewTags(String... tags) {
        onEditCampaignPage().saveNewTags(tags);
    }

    @Step("Переименовываем тег {0} в {1}")
    public void editTag(String oldTag, String newTag) {
        onEditCampaignPage().editTag(oldTag, newTag);
    }

    @Step("Удаляем тег {0}")
    public void deleteTag(String tag) {
        onEditCampaignPage().deleteTag(tag);
    }
}
