package ru.yandex.autotests.direct.web.steps.campaigns;


import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.WrapsElement;
import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.direct.web.data.BannerPreviewType;
import ru.yandex.autotests.direct.web.data.banners.BannerActionsEnum;
import ru.yandex.autotests.direct.web.data.banners.BannerSearchTypeEnum;
import ru.yandex.autotests.direct.web.data.banners.BannerTabsEnum;
import ru.yandex.autotests.direct.web.data.banners.MinusKeyWordsTypes;
import ru.yandex.autotests.direct.web.data.mediaplan.CopyBannerParameters;
import ru.yandex.autotests.direct.web.data.priceconstructor.BannerPhrasePlatform;
import ru.yandex.autotests.direct.web.data.priceconstructor.ConstructorMode;
import ru.yandex.autotests.direct.web.data.textresources.ShowCampaignPageTextData;
import ru.yandex.autotests.direct.web.data.textresources.Strings;
import ru.yandex.autotests.direct.web.objects.banners.BannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.BannerPhraseInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.MobileAppBannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.campaigns.GroupMultiplierStatsWeb;
import ru.yandex.autotests.direct.web.objects.campaigns.HelpRequestInfo;
import ru.yandex.autotests.direct.web.objects.deals.DealInfoWeb;
import ru.yandex.autotests.direct.web.objects.groups.feedfilter.DynamicFeedFilter;
import ru.yandex.autotests.direct.web.objects.groups.feedfilter.PerformanceFeedFilter;
import ru.yandex.autotests.direct.web.pages.showcampbem.ShowCampPage;
import ru.yandex.autotests.direct.web.pages.showcampbem.blocks.strategy.StrategyWeb;
import ru.yandex.autotests.direct.web.steps.AlertSteps;
import ru.yandex.autotests.direct.web.steps.CommonSteps;
import ru.yandex.autotests.direct.web.steps.UserSteps;
import ru.yandex.autotests.direct.web.steps.banners.BannerPhrasesBlockBemSteps;
import ru.yandex.autotests.direct.web.steps.campaigns.priceconstructor.PriceConstructorBemSteps;
import ru.yandex.autotests.direct.web.steps.campaigns.strategy.StrategySteps;
import ru.yandex.autotests.direct.web.util.helpers.URLParameterHelper;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;
import ru.yandex.qatools.allure.webdriver.steps.WebDriverSteps;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;

import static org.hamcrest.CoreMatchers.containsString;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.core.StringStartsWith.startsWith;
import static ru.yandex.autotests.direct.utils.beans.BeanWrapper.wrap;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;
import static ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies.onlyExpectedFields;
import static ru.yandex.qatools.allure.webdriver.matchers.HasURL.hasURL;
import static ru.yandex.qatools.htmlelements.matchers.common.HasTextMatcher.hasText;

public class ShowCampSteps extends BaseSteps {

    private AlertSteps alert() {
        return BaseSteps.getInstance(AlertSteps.class, config);
    }

    public ShowCampPage onShowCampPage() {
        return ShowCampPage.getInstance(ShowCampPage.class, config);
    }

    public CommonSteps inOperatingSystem() {
        return BaseSteps.getInstance(CommonSteps.class, config);
    }

    public BannerPhrasesBlockBemSteps onBannerPhrasesBemBlock() {
        BannerPhrasesBlockBemSteps steps = getInstance(BannerPhrasesBlockBemSteps.class, config, this);
        steps.forPage(onShowCampPage());
        return steps;
    }

    public PriceConstructorBemSteps onPriceConstructor() {
        PriceConstructorBemSteps steps = getInstance(PriceConstructorBemSteps.class, config, this);
        steps.forPage(onShowCampPage());
        return steps;
    }

    public StrategySteps onStrategyBlock() {
        StrategySteps steps = getInstance(StrategySteps.class, config, this);
        steps.forPage(onShowCampPage());
        return steps;
    }

    @Step("Активируем группу баннеров, id первого баннера {0}")
    public void activateBannerGroup(Long bannerId) {
        onShowCampPage().clickActivateBannerGroup(bannerId);
    }

    @Step("Отправляем на модерацию баннер id {0}")
    public void sendToModeration(Long bannerId) {
        onShowCampPage().clickSendToModeration(bannerId);
        alert().acceptIfPresent();
    }

    @Step("Останавливаем группу баннеров, id первого баннера {0}")
    public void stopBannerGroup(Long bannerId) {
        onShowCampPage().clickStopBannerGroup(bannerId);
    }

    @Step("Удаляем группу баннеров, id первого баннера {0}")
    public void deleteBannerGroup(Long bannerId) {
        onShowCampPage().clickDeleteBannerGroup(bannerId);
    }

    @Step("Открываем превью группы баннера {0}, ждем, пока он загрузится")
    public void openBannerGroupPreview(Long bannerId) {
        onShowCampPage().openBannerGroupPreviewAndWait(bannerId);
    }

    @Step("Нажимаем на редактирование группы баннеров {0}")
    public void clickEditBannerGroupByID(Long adGroupID) {
        onShowCampPage().clickEditBannerGroupInfoLinkByID(adGroupID);
    }

    @Step("Кликаем по изменению параметров")
    public void clickChangeParameters() {
        onShowCampPage().clickChangeParameters();
    }

    @Step("Кликаем по поиску объявлений")
    public void clickSearchBanners() {
        onShowCampPage().clickSearchBanners();
    }

    @Step("Заполняем поле признака поиска объявления")
    public void fillBannerSearchTypeInput(String inputText) {
        onShowCampPage().getBannersSearchBlock().fillBannerSearchTypeInput(inputText);
    }

    @Step("Выбираем способ поиска объявлений")
    public void chooseBannerSearchType(BannerSearchTypeEnum type) {
        onShowCampPage().getBannersSearchBlock().chooseBannerSearchType(type);
    }

    @Step("Кликаем по кнопке Искать в блоке поиска объявлений")
    public void clickSearchBannersButton() {
        onShowCampPage().getBannersSearchBlock().clickSearchBannersButton();
    }


    @Step("Сохраняем изменения, проверяем успешность сохранения и соглашаемся с алертом, если есть")
    public void clickSaveAndCheckSuccessAndAcceptAlertIfPresent() {
        waitForElement(onShowCampPage().getSaveButton().getWrappedElement(), 4, WebElementMatchers.isEnabled());
        onShowCampPage().clickSaveAndCheckButtonTextContains(
                ShowCampaignPageTextData.SAVE_PRICES_BUTTON_TEXT_SUCCESS.toString());
        alert().acceptIfPresent();
    }

    @Step("Сохраняем изменения и соглашаемся с алертом, если есть")
    public void clickSaveAndOkIfAlertPresent() {
        waitForElement(onShowCampPage().getSaveButton().getWrappedElement(), 2, WebElementMatchers.isEnabled());
        onShowCampPage().clickSave();
        alert().acceptIfPresent();
    }

    @Step("Сохраняем изменения, проверяем, что если есть алерт, то он и соглашамся")
    public void saveChangesWithAlert(Matcher matcher) {
        onShowCampPage().clickSave();
        inOperatingSystem().shouldSeePageBody(hasText(
                containsString(ShowCampaignPageTextData.CAMPAIGN_TEXT.toString())),
                DirectTestRunProperties.getInstance().getDirectWebWebdriverImplicityWaitTimeoutSec()
        );
        alert().acceptIfPresent(matcher);
    }

    @Step("Выполняем действие {0}")
    public void proceedAction(BannerActionsEnum action) {
        onShowCampPage().selectMassAction(action);
        onShowCampPage().clickProceedMassAction();
        alert().acceptIfPresent();
    }

    @Step("Выбираем баннер {0}")
    public void selectBanner(Long bannerId) {
        onShowCampPage().setBannerCheckboxState(bannerId, true);
    }

    @Step("Выбираем группу баннеров {0}")
    public void selectGroup(Long adGroupID) {
        onShowCampPage().setGroupCheckboxState(adGroupID, true);
    }

    @Step("Открываем оффлайн конструктор")
    public void openOfflineConstructor() {
        onShowCampPage().clickPricesForCampaign();
    }

    @Step("Проверяем, что сслыка 'Цены для всей кампании' удовлетворяет условию {0}")
    public void shouldSeePricesForCampaignLink(Matcher matcher) {
        onShowCampPage().checkPricesForCampaignLink(matcher);
    }

    @Step("Проверяем, что инлайн конструктор удовлетворяет условию {0}")
    public void shouldSeeInlineConstructor(Matcher matcher) {
        onShowCampPage().checkInlineConstructor(matcher);
    }

    @Step("Отправляем баннеры {0} на оптимизацию")
    public void sendBannersForOptimization(Long... bannerIds) {
        for (Long bannerId : bannerIds) {
            selectBanner(bannerId);
        }
        proceedAction(BannerActionsEnum.SEND_OPTIMIZE);
    }

    @Step("Выбираем таб {0}")
    public void selectBannersTab(BannerTabsEnum tab) {
        onShowCampPage().selectBannersTab(tab);
    }

    @Step("Проверяем, что количество баннеров на табе {0} {1}")
    public void shouldSeeBannersTabCount(BannerTabsEnum tab, Matcher matcher) {
        onShowCampPage().checkBannerTabCount(tab, matcher);
    }

    public void shouldNotSeeBannersTabs() {
        onShowCampPage().checkBannerTabListNotDisplayed();
    }

    public void shouldNotSeeBannerTab(BannerTabsEnum bannerTab) {
        shouldSeeBannerTab(bannerTab, equalTo(null));
    }

    @Step("Проверяем, что таб {0} {1}")
    public void shouldSeeBannerTab(BannerTabsEnum bannerTab, Matcher matcher) {
        onShowCampPage().checkBannerTab(bannerTab, matcher);
    }

    @Step("Находим id первого баннера")
    public Long getFirstBannerId() {
        Long bannedId = onShowCampPage().getFirstBannerId();
        AllureUtils.addTextAttachment("id баннера", bannedId.toString());
        return bannedId;
    }

    @Step("Находим id первой группы")
    public Long getFirstAdGroupID() {
        Long adGroupID = onShowCampPage().getFirstAdGroupID();
        AllureUtils.addTextAttachment("id группы", adGroupID.toString());
        return adGroupID;
    }

    @Step("Находим id последнего баннера")
    public Long getLastBannerId() {
        Long bannedId = onShowCampPage().getLastBannerId();
        AllureUtils.addTextAttachment("id баннера", bannedId.toString());
        return bannedId;
    }

    @Step("Проверяем, что ссылка на рекомендации {0}")
    public void shouldSeeShowRecommendationsLink(Matcher<WrapsElement> matcher) {
        onShowCampPage().checkShowRecommendationsLink(matcher);
    }

    @Step("Нажимаем добавить еще один баннер")
    public void clickAddBannerButton() {
        onShowCampPage().clickAddOneMoreBanner();
    }

    @Step("Нажимаем Настроить регионы показа")
    public void clickChangeRegionButton() {
        onShowCampPage().clickChangeRegionButton();
    }

    @Step("Нажимаем добавить еще одну группу ДО")
    public void clickAddDynamicGroupButton() {
        onShowCampPage().clickAddOneMoreDynamicBannerGroup();
    }

    @Step("Нажимаем добавить еще одну группу CPM")
    public void clickAddCpmGroupButton() {
        onShowCampPage().clickAddOneMoreCpmBannerGroup();
    }

    @Step("Нажимаем добавить еще одну группу РМП")
    public void clickAddMobileAppBannerButton() {
        onShowCampPage().clickAddOneMoreMobileAppBanner();
    }

    @Step("Нажимаем добавить еще одну МС группу")
    public void clickAddMcGroupButton() {
        onShowCampPage().clickAddOneMoreMcGroup();
    }

    @Step("Открываем попап настройки стратегии")
    public void clickChangeStrategyButton() {
        onShowCampPage().clickChangeStrategyButton();
    }

    @Step("Проверяем, что текст стратегии {0}")
    public void shouldSeeStrategyParametersText(Matcher matcher) {
        onShowCampPage().checkStrategyParametersText(matcher);
    }

    @Step("Проверяем, что статус кампании {0}")
    public void shouldSeeCampaignStatus(Matcher matcher) {
        onShowCampPage().checkCampStatus(matcher);
    }

    @Step("Выбираем все баннеры")
    public void selectAllBanners() {
        onShowCampPage().selectAllBanners();
    }

    /**
     * Открывает страницу оплаты кампании кликом по линку
     */
    @Step("Открываем страницу оплаты кампании кликом по линку")
    public void payForCampaign() {
        onShowCampPage().clickPayCampaign();
    }

    @Step("Получаем cid из адресной строки")
    public Long getCampaignID() {
        WebDriverSteps.getInstance(WebDriverSteps.class, config).waitForPage(hasURL(containsString("cid=")), 30);
        String cid = URLParameterHelper.getUrlParameterByName(config.getDriver().getCurrentUrl(), "cid");
        AllureUtils.addTextAttachment("cid", cid);
        return Long.parseLong(cid);
    }

    @Step("Создаем медиаплан")
    public void createMediaplan() {
        onShowCampPage().clickOpenMediaplanPanel();
        onShowCampPage().clickCreateMediaplan();
    }

    @Step("Отправляем запрос на медиаплан")
    public void sendRequestMediaplan() {
        onShowCampPage().clickOpenMediaplanPanel();
        onShowCampPage().clickSendRequestMediaplan();
    }

    @Step("Получаем ссылку на экспорт медиаплана в Excel")
    public String getExportMediaplanToExcelLink() {
        onShowCampPage().clickOpenMediaplanPanelOnMediaplanTab();
        return onShowCampPage().getExportMediaplanToExcelLink();
    }

    @Step("Копируем баннер в медиаплан с подтверждением алерта")
    public void copyBannerToMediaplan(IBeanWrapper<CopyBannerParameters> copyBannerParameters) {
        AllureUtils.addJsonAttachment("Параметры копирования", copyBannerParameters.toString());
        onShowCampPage().copyBannersInMediaplan(copyBannerParameters.getBean());
        alert().accept();
    }

    @Step("Запрашиваем первую помощь")
    public void requestFirstHelp(HelpRequestInfo helpOrderInfo) {
        AllureUtils.addJsonAttachment("Параметры запроса ПП", wrap(helpOrderInfo).toString());
        onShowCampPage().orderFirstHelp(helpOrderInfo);
    }

    @Step("Проверяем, что статус заявки на ПП {0}")
    public void shouldSeeHelpRequestState(Matcher<WebElement> matcher) {
        onShowCampPage().checkFirstHelpStatus(matcher);
    }

    @Step("Открываем страницу коментариев к ПП")
    public void openFirstHelpCommentPage() {
        onShowCampPage().clickFirstHelpComment();
    }

    @Step("Открываем подробную информацию об автокоррекции")
    public void openInformer(Long bannerId) {
        onShowCampPage().clickOpenInformer(bannerId);
    }

    @Step("Проверяем параметры превью баннера")
    public void shouldSeeBannerPreviewParameters(IBeanWrapper<BannerInfoWeb> expectedBanner) {
        AllureUtils.addJsonAttachment("Параметры превью баннера", expectedBanner.toString());
        onShowCampPage().checkBannerPreviewParameters(expectedBanner.getBean());
    }

    @Step("Проверяем наличие сообщения об автокоррекции")
    public void shouldSeeAutoCorrectionBannerPreview(Long bannerId, Matcher<WebElement> matcher) {
        onShowCampPage().shouldSeeAutoCorrectionBannerPreview(bannerId, matcher);
    }

    @Step("Проверяем параметры баннера до автокоррекции")
    public void shouldSeeAutoCorrectionBannerPreview(BannerInfoWeb expectedBanner) {
        AllureUtils.addJsonAttachment("Параметры не скорректированного баннера", JsonUtils.toString(expectedBanner));
        onShowCampPage().checkAutoCorrectionBanner(expectedBanner);
    }

    @Step("Проверяем параметры баннера до автокоррекции в попап превью")
    public void shouldSeeAutoCorrectionBannerPreviewPopup(BannerInfoWeb expectedBanner) {
        AllureUtils.addJsonAttachment("Параметры не скорректированного баннера", JsonUtils.toString(expectedBanner));
        onShowCampPage().checkAutoCorrectionBannerPreviewPopup(expectedBanner);
    }


    @Step("Проверяем параметры превью баннера мобильных приложений")
    public void shouldSeeMobileAppBannerPreviewParameters(IBeanWrapper<MobileAppBannerInfoWeb> expectedBanner) {
        AllureUtils.addJsonAttachment("Параметры превью баннера", expectedBanner.toString());
        onShowCampPage().checkMobileAppBannerPreviewParameters(expectedBanner.getBean());
    }

    @Step("Проверяем что минус слова {2} на фразу на {1} удовлетворяют условию {3}")
    public void shouldSeeMinusKeywordsOnPhrase(Matcher matcher,
                                               BannerPhrasePlatform platform,
                                               MinusKeyWordsTypes type,
                                               IBeanWrapper<BannerPhraseInfoWeb> exceptedPhrase) {
        AllureUtils.addJsonAttachment("Параметры фразы", exceptedPhrase.toString());
        onShowCampPage().checkMinusKeywordsOnPhrase(matcher, platform, type, exceptedPhrase.getBean());
    }

    @Step("Проверяем, что все минус слова на кампании {0}")
    public void shouldSeeCampaignMinusKeywords(Matcher<Collection<? extends String>> matcher) {
        onShowCampPage().checkCampaignMinusWords(matcher);
    }

    @Step("Заполняем единые минус слова на кампанию")
    public void fillCommonMinusKeyWordsSaveAndExpectSuccess(List<String> minusKeyWords) {
        AllureUtils.addTextAttachment("Минус слова", Arrays.toString(minusKeyWords.toArray()));
        onShowCampPage().fillCampaignMinusWordsSaveAndExpectSuccess(minusKeyWords);
    }

    @Step("Заполняем единые минус слова на кампанию")
    public void fillCommonMinusKeyWordsAndClickSave(List<String> minusKeyWords) {
        AllureUtils.addTextAttachment("Минус слова", Arrays.toString(minusKeyWords.toArray()));
        onShowCampPage().fillCampaignMinusWordsAndClickSave(minusKeyWords);
    }

    @Step("Выбираем платформу {0}")
    public void switchPhrasesPlatform(BannerPhrasePlatform platform) {
        if (onShowCampPage().getPlatformSwitcher().isDisplayed()) {
            onShowCampPage().switchPlatform(platform);
        }
    }

    @Step("Проверяем, что переключатель платформы {0}")
    public void shouldSeeContextSearchSwitcher(Matcher matcher) {
        onShowCampPage().checkContextSearchSwitcher(matcher);
    }

    public void usingConstructorMode(ConstructorMode mode) {
        onShowCampPage().forConstructorMode(mode);
    }

    @Step("Проверяем, что ссылка на редактирование первого баннера {0}")
    public void shouldSeeFirstBannerEditLink(Matcher matcher) {
        onShowCampPage().checkFirstEditBannerLink(matcher);
    }

    @Step("Проверяем, что блок превью баннера {0} {1}")
    public void shouldSeeBannerPreviewBlock(Long bannerId, Matcher matcher) {
        onShowCampPage().checkPreviewGroup(bannerId, matcher);
    }

    @Step("Проверяем, что объявление {1} в блоке превью баннера {0} соответствует {2}")
    public void shouldSeeBannerOnGroupPreview(Long parentBannerId, Long childBannerId, Matcher matcher) {
        onShowCampPage().checkBannerOnGroupPreview(parentBannerId, childBannerId, matcher);
    }

    @Step("Проверяем диапазон корректировки")
    public void shouldSeeAdjustmentRange(IBeanWrapper<GroupMultiplierStatsWeb> groupMultiplierStatsWeb) {
        AllureUtils.addJsonAttachment("Параметры превью баннера", groupMultiplierStatsWeb.toString());
        onShowCampPage().checkAdjustmentRangeText(groupMultiplierStatsWeb.getBean());
    }

    @Step("Заполняем минус слова на объявление")
    public void fillMinusKeywordsAndSave(Long bannerId, String[] minusKeywords) {
        String keywords = "-" + StringUtils.join(minusKeywords, " -");
        AllureUtils.addTextAttachment("Минус слова", keywords);
        onShowCampPage().fillMinusKeywordsAndSave(bannerId, keywords);
    }

    @Step("Добавляем теги группе {0}")
    public void setTagsForGroup(Long adGroupID, String... tags) {
        AllureUtils.addTextAttachment("Теги", Arrays.asList(tags).toString());
        onShowCampPage().setTagsForGroup(adGroupID, tags);
    }

    @Step("Добавляем теги баннеру {0}")
    public void setTagsForBanner(Long bannerId, String... tags) {
        AllureUtils.addTextAttachment("Теги", Arrays.asList(tags).toString());
        onShowCampPage().setTagsForBanner(bannerId, tags);
    }

    @Step("Добавляем новые теги баннеру {0}")
    public void fillNewTagsForBanner(Long bannerId, String... tags) {
        AllureUtils.addTextAttachment("Теги", Arrays.asList(tags).toString());
        onShowCampPage().fillNewTagsForBanner(bannerId, tags);
    }

    @Step("Сохраняем новые теги баннеру {0}")
    public void saveNewTagsForBanner(Long bannerId) {
        onShowCampPage().saveNewTagsForBanner(bannerId);
    }

    @Step("Открываем попап тегов")
    public void openTagsPopup() {
        onShowCampPage().clickOpenTags();
        takeScreenshot();
    }

    @Step("Добавляем теги выбранным баннерам")
    public void setTagsForSelectedBanners(String... tags) {
        AllureUtils.addTextAttachment("Теги", Arrays.asList(tags).toString());
        onShowCampPage().setTagsForSelectedBannersUsingGroupAction(tags);
    }

    @Step("Нажимаем на Задать/редактировать метки")
    public void openEditCampaignTagPage() {
        onShowCampPage().clickOpenTags();
        onShowCampPage().clickOnAddOrEditTagLinkOnTagsPopupBlock();
    }

    @Step("Открываем баннеры без тегов")
    public void showBannersWithoutTags() {
        onShowCampPage().clickOpenTags();
        onShowCampPage().clickOnShowBannersWithoutTagsLink();
    }

    @Step("Проверяем, что все теги {0}")
    public void shouldSeeTags(Matcher<Iterable<? extends String>> matcher) {
        onShowCampPage().checkTags(matcher);
    }

    @Step("Кликаем на тег {0}")
    public void clickTagLink(String tag) {
        onShowCampPage().clickOnTag(tag);
    }

    @Step("Получаем все баннеры кампании")
    public List<Long> getBannerIds() {
        List<Long> ids = onShowCampPage().getBannerIds();
        AllureUtils.addTextAttachment("id шники баннеров", ids.toString());
        return ids;
    }

    @Step("Кликаем на ссыку показать статистику")
    public void showStatistics() {
        onShowCampPage().clickOnShowStatisticsLink();
    }

    // Banner group

    @Step("Выбор страницы {0}")
    public void selectPage(String pageNumber) {
        onShowCampPage().selectPage(pageNumber);
    }

    @Step("Установка тумблера для объявления {0} в статус {1}")
    public void selectTumbler(Long bannerId, Boolean status) {
        onShowCampPage().selectBannersGroupTumbler(bannerId, status);
    }

    @Step("Кликаем на ссылку вызова информации о группе объявлений")
    public void clickBannersGroupInfoLink(Long bannerGroupId) {
        onShowCampPage().clickBannersGroupInfoLink(bannerGroupId);
    }

    @Step("Нажатие на кнопку 'Сохранить' во всплывающем окне предпросмотра группы объявлений")
    public void clickBannersGroupPreviewPopupSaveButton() {
        onShowCampPage().clickBannersGroupSaveButton();
    }

    @Step("Нажатие на кнопку 'Отмена' во всплывающем окне предпросмотра группы объявлений")
    public void clickBannersGroupPreviewPopupCancelButton() {
        onShowCampPage().clickBannersGroupCancelButton();
    }


    @Step("Нажатие на крестик закрытия всплывающего окна с информацией о группе баннеров")
    public void clickBannersGroupPreviewPopupCloseWebElement() {
        onShowCampPage().clickBannersGroupCloseWebElement();
    }

    @Step("Нажатие на ссылку 'Редактировать группу' для баннера {0}")
    public void editGroupWithBanner(Long bannerId) {
        onShowCampPage().clickEditGroupLink(bannerId);
    }

    @Step("Нажатие на ссылку 'Копировать группу' {0}")
    public void copyBanner(Long bannerId) {
        onShowCampPage().clickCopyBannersGroupLink(bannerId);
        UserSteps.getInstance(UserSteps.class, config).inOperatingSystem()
                .waitForPageTitle(startsWith(Strings.TITLE_CREATE_GROUP_OF_BANNERS));
    }

    @Step("Нажатие на кнопку 'Удалить' у баннера {0}")
    public void clickBannersGroupRemoveButton(Long bannerId, Matcher<String> matcher) {
        onShowCampPage().clickBannersGroupRemoveButton(bannerId);
        alert().accept(matcher);
        onShowCampPage().waitWhileBannerGroupPreviewPopupLoadingComplete();
    }

    @Step("Нажатие кнопки 'Архивировать' у баннера {0}")
    public void clickBannersGroupArchiveItem(Long bannerId) {
        onShowCampPage().clickBannersGroupArchiveItem(bannerId);
    }

    @Step("Нажатие кнопки 'Разрхивировать' у баннера {0}")
    public void clickBannersGroupUnArchiveItem(Long bannerId) {
        onShowCampPage().clickBannersGroupUnArchiveItem(bannerId);
        AlertSteps.getInstance(AlertSteps.class, config).acceptIfPresent();
        onShowCampPage().waitWhileBannerGroupPreviewPopupLoadingComplete();
    }

    @Step("Выбор типа отображаемого превью")
    public void clickBannerPreviewType(BannerPreviewType type) {
        onShowCampPage().clickBannerPreviewType(type);
    }

    @Step("Нажатие на ссылку 'Архив' во всплывающем окне")
    public void clickBannersGroupArchiveWebElement() {
        onShowCampPage().clickBannersGroupArchiveWebElement();
    }

    @Step("Нажатие на ссылку 'Все объявления' во всплывающем окне")
    public void clickBannersGroupAllBannersWebElement() {
        onShowCampPage().clickBannersGroupAllBannersWebElement();
    }

    @Step("Проверка данных баннера {0}")
    public void shouldSeeBannersGroupBean(Long bannerId, BeanEquals<BannerInfoWeb> matcher) {
        onShowCampPage().checkBannersGroupItemBean(bannerId, matcher);
    }

    @Step("Проверка данных баннера мобильных приложений {0}")
    public void shouldSeeMobileAppBannersGroupBean(Long bannerId, BeanEquals<MobileAppBannerInfoWeb> matcher) {
        onShowCampPage().checkMobileAppBannersGroupItemBean(bannerId, matcher);
    }

    @Step("Проверка данных баннера {0}")
    public void shouldSeeBannersGroupBean(IBeanWrapper<BannerInfoWeb> bannerInfo) {
        onShowCampPage().checkBannersGroupItemBean(bannerInfo);
    }

    @Step("Проверка данных баннера мобильных приложений {0}")
    public void shouldSeeMobileAppBannersGroupBean(IBeanWrapper<MobileAppBannerInfoWeb> bannerInfo) {
        onShowCampPage().checkMobileAppBannersGroupItemBean(bannerInfo);
    }


    @Step("Проверка статуса тумблера объявления {0} условию {1}")
    public void shouldSeeBannersGroupTumblerStatus(Long bannerId, Matcher<Boolean> matcher) {
        onShowCampPage().checkBannersGroupTumblerStatus(bannerId, matcher);
    }

    @Step("Проверка, что превью группы баннеров {0} условию {1}")
    public void shouldSeeBannersGroup(Long bannerId, Matcher<WebElement> matcher) {
        onShowCampPage().checkPreviewGroup(bannerId, matcher);
    }


    @Step("Проверка баннера {1} условию {2}")
    public void shouldSeeBannersGroupItem(Long bannerId, Matcher<WebElement> matcher) {
        onShowCampPage().checkBannersGroupItem(bannerId, matcher);
    }

    @Step("Получение заголовка группы баннеров с главным баннером {0}")
    public String getBannersGroupTitle(Long bannerId) {
        return onShowCampPage().getBannersGroupTitle(bannerId);
    }

    @Step("Установка флажка для группы баннеров {0} в статус {1}")
    public void setBannersGroupCheckBox(Long bannersGroupId, boolean status) {
        onShowCampPage().setBannerCheckboxState(bannersGroupId, status);
    }

    @Step("Проверяем, что текст алерта на странице кампании соответствует {0}")
    public void shouldSeeAlertText(Matcher<String> matcher) {
        alert().shouldSeeAlertText(matcher);
    }

    @Step("Проверяем, что остаток средств на кампании удовлетворяет условию {0}")
    public void shouldSeeCampaignSum(Matcher matcher) {
        onShowCampPage().checkCampaignSum(matcher);
    }

    @Step("Проверяем, что скидочный бонус удовлетворяет условию {0}")
    public void shouldSeeDiscountBonus(Matcher matcher) {
        onShowCampPage().checkDiscountBonus(matcher);
    }

    @Step("Проверяем, что число баннеров в группе с первым баннером {0} удовлетворяет условию {1}")
    public void shouldSeeGroupBannerCount(Long firstBannerInGroupId, Matcher matcher) {
        onShowCampPage().checkBannerGroupCount(firstBannerInGroupId, matcher);
    }

    @Step("Проверяем, что флаг баннера {0} удовлетворяет условию {1}")
    public void shouldSeeBannerFlag(Long bannerId, Matcher<WebElement> matcher) {
        onShowCampPage().checkBannerFlag(bannerId, matcher);
    }

    @Step("Установка предупреждения БАД для баннера {0}")
    public void setDietarySupplFlagForBanner(Long bannerId) {
        onShowCampPage().setDietarySupplBannerFlag(bannerId);
    }

    @Step("Заполнение параметров фильтра фида")
    public void fillPerformanceFilter(PerformanceFeedFilter filter) {
        AllureUtils.addJsonAttachment("Параметры фильтра фида", JsonUtils.toString(filter));
        onShowCampPage().fillPerformanceFilter(filter);
    }

    @Step("Заполнение параметров фильтра фида ДО")
    public void fillDynamicFilter(DynamicFeedFilter filter) {
        AllureUtils.addJsonAttachment("Параметры фильтра фида", JsonUtils.toString(filter));
        onShowCampPage().fillDynamicFilter(filter);
    }

    @Step("Проверка параметров фильтра фида")
    public void checkPerformanceFilter(BeanDifferMatcher<PerformanceFeedFilter> matcher) {
        AllureUtils.addJsonAttachment("Параметры фильтра фида", JsonUtils.toString(matcher.getExpectedBean()));
        onShowCampPage().checkPerformanceFilter(matcher);
    }

    public void checkPerformanceFilter(PerformanceFeedFilter feedFilter) {
        checkPerformanceFilter(beanDiffer(feedFilter).useCompareStrategy(onlyExpectedFields()));
    }

    @Step("Проверка параметров фильтра фида")
    public void checkDynamicFilter(BeanDifferMatcher<DynamicFeedFilter> matcher) {
        AllureUtils.addJsonAttachment("Параметры фильтра фида", JsonUtils.toString(matcher.getExpectedBean()));
        onShowCampPage().checkDynamicFilter(matcher);
    }

    @Step("Проверка блока фильтров фида")
    public void shouldSeeFilterPopupBlock(Matcher matcher) {
        onShowCampPage().shouldSeeFilterPopupBlock(matcher);
    }

    @Step("Получение блока с фразами по id баннера")
    public WebElement getPhrasesBlockByBanner(Long bannerId) {
        return onShowCampPage().getBannerPreviewWithPhrasesBlockByBannerIdAndExpectSuccess(bannerId).getPhrasesBlock();
    }

    @Step("Нажатие кнопки остановки/возобновления показов")
    public void clickOnResumeAndStopCampaignButton() {
        onShowCampPage().clickResumeAndStopCampaignButton();
    }

    @Step("Кнопка остановки/возобновления показов должна соответствовать ожиданию: {0}")
    public void shouldSeeResumeAndStopCampaignButton(Matcher matcher) {
        onShowCampPage().shouldSeeResumeAndStopCampaignButton(matcher);
    }

    @Step("Установка ставки для условия нацеливания в динамической группе")
    public void setDynamicTargetPriceInGroup(Long adgroupId, String targetName, Float price) {
        onShowCampPage().fillDynamicTargetPriceInGroup(adgroupId, targetName, price);
    }

    @Step("Проверка ставки для условия нацеливания в динамической группе")
    public void checkDynamicTargetPriceInGroup(Long adgroupId, String targetName, String expectedPrice) {
        onShowCampPage().checkDynamicTargetPriceInGroup(adgroupId, targetName, expectedPrice);
    }

    @Step("Установка ставки для фильтра в смарт-кампании")
    public void setSmartFilterPriceInGroup(Long adgroupId, String filterName, Float price) {
        onShowCampPage().fillSmartFilterPriceInGroup(adgroupId, filterName, price);
    }

    @Step("Проверка ставки для фильтра в смарт-кампании")
    public void checkSmartFilterPriceInGroup(Long adgroupId, String filterName, String expectedPrice) {
        onShowCampPage().checkSmartFilterPriceInGroup(adgroupId, filterName, expectedPrice);
    }

    @Step("Кликаем на ссылку единые минус-слова на кампанию")
    public void openCampaignMinusWords() {
        onShowCampPage().clickOpenCampaignMinusWords();
    }

    @Step("Кликаем на ссылку минус-слова на группу")
    public void openAdGroupMinusWords(Long adGroupID) {
        onShowCampPage().openAdGroupMinusWordsPopup(adGroupID);
    }

    @Step("Привязываем сделки")
    public void linkDealsWithIds(Long... ids) {
        selectDealsStateWithIds(true, ids);
    }

    @Step("Отвязываем сделки")
    public void unlinkDealsWithIds(Long... ids) {
        selectDealsStateWithIds(false, ids);
    }

    private void selectDealsStateWithIds(boolean state, Long... ids) {
        AllureUtils.addTextAttachment("Id сделок", wrap(ids).toString());
        onShowCampPage().clickOpenDealPopupAndWaitDealPopupDisplayed();
        Stream.of(ids).forEach(id ->
                onShowCampPage().onDealsPopup().setDealSelectedById(id, state));

        onShowCampPage().onDealsPopup().clickSave();
        waitForElement(onShowCampPage().onDealsPopup(), 5, not(WebElementMatchers.isDisplayed()));
    }

    @Step("Получение привязанных к кампании сделок")
    public List<DealInfoWeb> getLinkedDeals() {
        onShowCampPage().clickOpenDealPopupAndWaitDealPopupDisplayed();
        List<DealInfoWeb> linkedDeals = onShowCampPage().onDealsPopup().getSelectedDeals();
        onShowCampPage().onDealsPopup().clickCancelButton();
        waitForElement(onShowCampPage().onDealsPopup(), 5, not(WebElementMatchers.isDisplayed()));
        return linkedDeals;
    }

    @Step("Проверяем текст привязнных сделок")
    public void linkedDealsTextShouldBe(Matcher<String> matcher) {
        onShowCampPage().checkLinkedDealsText(matcher);
    }

    public void checkDealRowsShouldBeDisabled(Long... dealIds) {
        onShowCampPage().clickOpenDealPopupAndWaitDealPopupDisplayed();
        onShowCampPage().onDealsPopup().checkDealRowsAreDisabled(dealIds);
        onShowCampPage().onDealsPopup().clickCancelButton();
        waitForElement(onShowCampPage().onDealsPopup(), 5, not(WebElementMatchers.isDisplayed()));
    }

    @Step("Заполняем параметры стратегии и сохраняем")
    public void fillCampaignStrategy(StrategyWeb strategy) {
        onShowCampPage().fillCampaignStrategyWithSuccess(strategy);
    }

    @Step("Заполняем параметры стратегии и проверяем ошибку")
    public void fillCampaignStrategyAndCheckError(StrategyWeb strategy, String errorText) {
        onShowCampPage().fillCampaignStrategyAndCheckError(strategy, errorText);
    }

    @Step("Проверяем параметры стратегии")
    public void checkCampaignStrategy(StrategyWeb expectedStrategy) {
        onShowCampPage().checkCampaignStrategy(expectedStrategy);
    }
}
