package ru.yandex.autotests.direct.web.steps.campaigns;

import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.utils.matchers.BeanCompareStrategy;
import ru.yandex.autotests.direct.utils.textresource.TextResourceFormatter;
import ru.yandex.autotests.direct.web.data.banners.BannerActionsEnum;
import ru.yandex.autotests.direct.web.data.banners.BannerTabsEnum;
import ru.yandex.autotests.direct.web.data.firsthelp.FirstHelpConstants;
import ru.yandex.autotests.direct.web.data.firsthelp.OptimizeAction;
import ru.yandex.autotests.direct.web.data.firsthelp.recommendations.AcceptRecommendedBannerParameters;
import ru.yandex.autotests.direct.web.data.firsthelp.recommendations.AcceptRecommendedBannersType;
import ru.yandex.autotests.direct.web.data.mediaplan.AcceptMediaplanParameters;
import ru.yandex.autotests.direct.web.data.mediaplan.MediaplanPhrasesMassActionType;
import ru.yandex.autotests.direct.web.data.priceconstructor.MediaplanTrafficVolume;
import ru.yandex.autotests.direct.web.data.textresources.Strings;
import ru.yandex.autotests.direct.web.objects.banners.BannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.ForecastInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.OptimizedBannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.OptimizedPhraseInfoWeb;
import ru.yandex.autotests.direct.web.objects.campaigns.HelpRequestInfo;
import ru.yandex.autotests.direct.web.pages.campaigns.OrderCampaignOptimizingPage;
import ru.yandex.autotests.direct.web.pages.campaigns.ShowMediaplanPage;
import ru.yandex.autotests.direct.web.pages.clients.AcceptOptimizePage;
import ru.yandex.autotests.direct.web.steps.UserSteps;
import ru.yandex.autotests.direct.web.steps.banners.BannerPhrasesBlockSteps;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.util.helpers.TextResourceHelper;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.AlertSteps;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import java.util.List;

import static org.hamcrest.Matchers.containsString;
import static org.hamcrest.core.StringStartsWith.startsWith;
import static ru.yandex.autotests.direct.utils.beans.BeanWrapper.wrap;
import static ru.yandex.autotests.direct.utils.matchers.TextResourceMatcher.textResourceMatcher;

public class ShowMediaplanSteps extends BaseSteps {

    private OrderCampaignOptimizingPage onOrderCampaignOptimizingPage() {
        return OrderCampaignOptimizingPage.getInstance(OrderCampaignOptimizingPage.class, config);
    }

    private ShowMediaplanPage onShowMediaplanPage() {
        return ShowMediaplanPage.getInstance(ShowMediaplanPage.class, config);
    }

    private AcceptOptimizePage onAcceptOptimizePage() {
        return AcceptOptimizePage.getInstance(AcceptOptimizePage.class, config);
    }

    public BannerPhrasesBlockSteps onBannerPhrasesBlock() {
        return getInstance(BannerPhrasesBlockSteps.class, config, this);
    }

    @Step
    public void fillHelpRequestParameters(IBeanWrapper<HelpRequestInfo> helpRequestInfo) {
        onOrderCampaignOptimizingPage().fillHelpRequestParameters(helpRequestInfo.getBean());
    }

    @Step
    public void sendCampaignToFirstHelp() {
        onOrderCampaignOptimizingPage().clickOnSubmitOrderButton();
    }

    @Step
    public void shouldSeeAcceptedOrderMessage(Matcher matcher) {
        onOrderCampaignOptimizingPage().checkAcceptedOrderMessage(matcher);
    }

    @Step
    public void completeOptimization(OptimizeAction... optimizeActions) {
        onShowMediaplanPage().submitOptimize(optimizeActions);
    }

    @Step
    public void proceedPhrasesAction(MediaplanPhrasesMassActionType action) {
        onShowMediaplanPage().proceedPhrasesAction(action);
        AlertSteps.getInstance(AlertSteps.class, config).acceptIfPresent();
    }

    @Step
    public void acceptRecommendationBanners() {
        onAcceptOptimizePage().clickOnAcceptOptimizeBanners();
        AlertSteps.getInstance(AlertSteps.class, config).acceptIfPresent();
    }

    @Step
    public Long getMediaplanIdByBannerId(Long mediaplanId) {
        return onShowMediaplanPage().getMediaplanIdByBannerId(mediaplanId);
    }

    @Step
    public void shouldSeeClientMonthBudget(Matcher matcher) {
        onShowMediaplanPage().checkClientMonthBudget(matcher);
    }

    @Step
    public void expandOptimizeTextBlock() {
        onShowMediaplanPage().expandOptimizeTextBlock();
    }

    @Step
    public void shouldSeeOptimizeTextOnMoreBlock(Matcher matcher) {
        onShowMediaplanPage().checkOptimizeText(matcher);
    }

    @Step
    public void shouldSeeBannerFrameBlock(Matcher matcher) {
        onShowMediaplanPage().checkBannerFrameBlocks(matcher);
    }

    @Step
    public void shouldSeeBannerPreviewParameters(IBeanWrapper<BannerInfoWeb> expectedBanner) {
        onShowMediaplanPage().checkBannerPreviewParameters(expectedBanner.getBean());
    }

    @Step
    public void finishMediaplan() {
        onShowMediaplanPage().clickFinishMediaplanButton();
        onShowMediaplanPage().clickSendToClientButton();
        try {
            Thread.sleep(5000);
            AlertSteps alertSteps = AlertSteps.getInstance(AlertSteps.class, config);
            alertSteps.accept();
        }
        catch (Exception e) {
            throw new DirectWebError("проблема при попытке закончить медиаплан");
        }
    }

    @Step
    public void shouldSeeFinishMediaplanButton(Matcher matcher) {
        onShowMediaplanPage().checkFinishMediaplanButton(matcher);
    }

    @Step
    public void shouldSeeAddAnotherMediaplanBlockButton(Matcher matcher) {
        onShowMediaplanPage().checkAddAnotherMediaplanBlockButton(matcher);
    }

    @Step
    public void shouldSeeMediaplanStatusText(Matcher matcher) {
        onShowMediaplanPage().checkMediaplanStatusText(matcher);
    }

    @Step
    public void shouldSeeApproveMediaplanButton(Matcher matcher) {
        onShowMediaplanPage().checkApproveMediaplanButton(matcher);
    }

    @Step
    public void shouldSeeMediaplanNumber(Long bannerID, Matcher matcher) {
        onShowMediaplanPage().checkBannerNumber(bannerID, matcher);
    }

    @Step
    public void selectAllMediaplans() {
        onShowMediaplanPage().clickSelectAllMediaplans();
    }

    @Step
    public Long getFirstBannerID() {
        return onShowMediaplanPage().getFirstBannerId();
    }

    @Step
    public Long getLastBannerID() {
        return onShowMediaplanPage().getLastBannerId();
    }

    @Step
    public List<Long> getBannerIds() {
        return onShowMediaplanPage().getBannerIds();
    }

    @Step
    public void editMediaplan(Long mediaplanID) {
        onShowMediaplanPage().clickEditMediaplan(mediaplanID);
    }

    @Step
    public void selectMediaplanCheckBox(Long mediaplanID) {
        onShowMediaplanPage().selectMediaplanCheckBox(mediaplanID);
    }

    @Step
    public void copyMediaplan(Long mediaplanID) {
        onShowMediaplanPage().clickCopyMediaplan(mediaplanID);
    }

    @Step
    public void deleteMediaplan(Long mediaplanID) {
        onShowMediaplanPage().clickDeleteMediaplan(mediaplanID);
    }

    @Step
    public void proceedAction(BannerActionsEnum action) {
        onShowMediaplanPage().proceedAction(action);
    }

    @Step
    public void acceptMediaplanWithParametersWithConfirm(IBeanWrapper<AcceptMediaplanParameters> parameters) {
        onShowMediaplanPage().fillAcceptMediaplanParametersAndAccept(parameters.getBean());
        AlertSteps alertSteps = AlertSteps.getInstance(AlertSteps.class, config);
        alertSteps.acceptIfPresent();
        getInstance(UserSteps.class, config).inOperatingSystem()
                .waitForPageTitle(startsWith(Strings.TITLE_CAMPAIGN_VIEW));
    }

    public void setAcceptRecommendationParameters(AcceptRecommendedBannersType acceptRecommendedBannersType,
                                                  Boolean stopOldBanners, Boolean archiveOldBanners) {
        AcceptRecommendedBannerParameters parameters = new AcceptRecommendedBannerParameters(
                acceptRecommendedBannersType, stopOldBanners, archiveOldBanners);
        acceptRecomemndationWithParameters(wrap(parameters));
    }

    @Step
    public void acceptRecomemndationWithParameters(IBeanWrapper<AcceptRecommendedBannerParameters> parameters) {
        onShowMediaplanPage().fillAcceptRecommendationParametersAndSubmit(parameters.getBean());
        AlertSteps.getInstance(AlertSteps.class, config).acceptIfPresent();
    }

    @Step
    public void clickAddAnotherMediaplanBlockButton() {
        onShowMediaplanPage().clickAddAnotherMediaplanBlockButton();
    }

    @Step
    public void fillMinusKeywordsAndSave(Long mediaplanID, String[] minusKeywords) {
        String keywords = "-" + StringUtils.join(minusKeywords, " -");
        onShowMediaplanPage().fillMinusKeywordsAndSave(mediaplanID, keywords);
    }

    @Step
    public void shouldSeeActionInfo(Matcher matcher) {
        onShowMediaplanPage().checkActionsInfo(matcher);
    }

    @Step
    public void removeDuplicates() {
        onShowMediaplanPage().removeDuplicates();
    }

    @Step
    public void correctIntersection() {
        onShowMediaplanPage().correctIntersection();
    }

    @Step
    public void shouldSeeMediaplanBlock(Long mediaplanID, Matcher matcher) {
        onShowMediaplanPage().checkMediaplanFrameBlock(mediaplanID, matcher);
    }

    @Step
    public void declineOptimizationWithConfirm(String comment) {
        onShowMediaplanPage().declineOptimization(comment);
        try {
            Thread.sleep(2000);
            AlertSteps alertSteps = AlertSteps.getInstance(AlertSteps.class, config);
            alertSteps.acceptIfPresent();
        }
        catch (Exception e) {
            throw new DirectWebError("ошибка при отклонении рекомендации");
        }
    }

    @Step
    public void savePrices() {
        onShowMediaplanPage().savePrices();
    }

    @Step
    public void fillPhraseParameters(IBeanWrapper<OptimizedPhraseInfoWeb> phrase) {
        onShowMediaplanPage().fillPhraseParameters(phrase.getBean());
    }

    @Step
    public void shouldSeePhrase(IBeanWrapper<OptimizedPhraseInfoWeb> phraseInfo) {
        onShowMediaplanPage().checkPhraseParameters(phraseInfo.getBean());
    }

    @Step
    public void setPriceType(MediaplanTrafficVolume priceType) {
        onShowMediaplanPage().setTrafficVolume(priceType);
    }

    @Step
    public void removeRecommendationsWithConfirm(String comment) {
        onShowMediaplanPage().removeRecommendations(comment);
        try {
            Thread.sleep(2000);
            AlertSteps alertSteps = AlertSteps.getInstance(AlertSteps.class, config);
            alertSteps.acceptIfPresent();
        }
        catch (Exception e) {
            throw new DirectWebError("ошибка при отклонении рекомендации");
        }
    }

    @Step
    public void showWeekForecast() {
        onShowMediaplanPage().clickOnWeekForecast();
    }

    @Step
    public void showMonthForecast() {
        onShowMediaplanPage().clickOnMonthForecast();
    }

    @Step
    public void shouldSeeTotalBannerForecast(IBeanWrapper<ForecastInfoWeb> forecastInfoWeb,
                                             BeanCompareStrategy compareStrategy) {
        onShowMediaplanPage().checkForecasts(forecastInfoWeb.getBean(), compareStrategy);
    }

    @Step
    public void shouldSeeTotalForecastForAllBanners(IBeanWrapper<ForecastInfoWeb> forecastInfoWeb,
                                                    BeanCompareStrategy compareStrategy) {
        onShowMediaplanPage().checkForecastsForAllBanners(forecastInfoWeb.getBean(), compareStrategy);
    }

    @Step
    public ForecastInfoWeb getForecastForAllBanners(IBeanWrapper<ForecastInfoWeb> forecastInfoWebIBean) {
        return onShowMediaplanPage().getForecastForAllBannersFieldsAccording(forecastInfoWebIBean.getBean());
    }

    @Step
    public ForecastInfoWeb calculateTotalBannerForecasts(
            IBeanWrapper<OptimizedBannerInfoWeb> optimizedBannerInfoWeb) {
        return onShowMediaplanPage().calculateTotalBannerForecast(optimizedBannerInfoWeb.getBean());
    }

    @Step
    public ForecastInfoWeb calculateForecastForAllBanners(
            List<Long> bannerIDs, IBeanWrapper<OptimizedBannerInfoWeb> expectedOptimizedBanner) {
        return onShowMediaplanPage().calculateForecastForAllBanners(bannerIDs, expectedOptimizedBanner.getBean());
    }

    @Step
    public OptimizedPhraseInfoWeb getOptimizedPhraseFieldsAccording(OptimizedPhraseInfoWeb phrase) {
        return onShowMediaplanPage().getOptimizedPhraseFieldsAccording(phrase);
    }

    @Step("Получаем CTR входа в гарантию для фразы {0}")
    public Double getGuaranteeCTRForPhrase(OptimizedPhraseInfoWeb phrase) {
        return onShowMediaplanPage().getGuaranteeCTRForPhrase(phrase);
    }

    @Step
    public void selectBannersTab(BannerTabsEnum tab) {
        onShowMediaplanPage().selectBannersTab(tab);
    }

    @Step
    public void shouldSeeBannersTabCount(BannerTabsEnum tab, Matcher matcher) {
        onShowMediaplanPage().checkBannerTabCount(tab, matcher);
    }
}
