package ru.yandex.autotests.direct.web.steps.campaigns.priceconstructor;

import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.web.data.CheckBoxStates;
import ru.yandex.autotests.direct.web.data.groupenums.FeedsFilterConditionsField;
import ru.yandex.autotests.direct.web.data.priceconstructor.ConstructorPlatformSelect;
import ru.yandex.autotests.direct.web.data.priceconstructor.ContextConstructor;
import ru.yandex.autotests.direct.web.data.priceconstructor.OfflineConstructorForm;
import ru.yandex.autotests.direct.web.data.priceconstructor.SearchConstructor;
import ru.yandex.autotests.direct.web.pages.priceconstructor.IPriceConstructorProvider;
import ru.yandex.autotests.direct.web.pages.priceconstructor.PriceConstructorBem;
import ru.yandex.autotests.direct.web.steps.AlertSteps;
import ru.yandex.autotests.direct.web.steps.CommonSteps;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import static java.lang.Thread.sleep;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class PriceConstructorBemSteps extends BaseSteps {

    private IPriceConstructorProvider pageWithConstructor;

    public void forPage(IPriceConstructorProvider pageWithConstructor) {
        this.pageWithConstructor = pageWithConstructor;
    }

    private PriceConstructorBem onConstructorForm() {
        return pageWithConstructor.getConstructor();
    }

    public CommonSteps inOperatingSystem() {
        return BaseSteps.getInstance(CommonSteps.class, config);
    }

    @Step("Выбираем платформу {0} в конструкторе")
    public void selectConstructorPlatform(ConstructorPlatformSelect platform) {
        onConstructorForm().selectPlatform(platform);
    }

    @Step("Устанавливаем галочку 'на поиске' в состояние {0}")
    public void setConstructorForSearch(CheckBoxStates state) {
        onConstructorForm().setConstructorForSearchCheckBox(state.getValue());
    }

    @Step("Проверяем, что галка 'на поиске' удовлетворяет условию {0}")
    public void shouldSeeConstructorForSearchCheckBox(Matcher matcher) {
        onConstructorForm().checkChooseSearchCheckBox(matcher);
    }

    @Step("Устанавливаем галочку 'на площадках' в состояние {0}")
    public void setConstructorForContext(CheckBoxStates state) {
        onConstructorForm().setConstructorForContextCheckBox(state.getValue());
    }

    @Step("Заполняем поля конструктора на поиске")
    public void fillSearchConstructorWith(IBeanWrapper<SearchConstructor> constructor) {
        AllureUtils.addJsonAttachment("Параметры конструктора", constructor.toString());
        onConstructorForm().fillSearchParameters(constructor.getBean());
    }

    @Step("Заполняем поля конструктора на тематических площадках")
    public void fillContextConstructorWith(IBeanWrapper<ContextConstructor> constructor) {
        AllureUtils.addJsonAttachment("Параметры конструктора", constructor.toString());
        onConstructorForm().fillContextParameters(constructor.getBean());
    }

    @Step("Проверяем поля конструктора на поиске")
    public void shouldSeeSearchConstructorParameters(IBeanWrapper<SearchConstructor> constructor) {
        AllureUtils.addJsonAttachment("Ожидаемые параметры конструктора", constructor.toString());
        onConstructorForm().checkSearchParameters(constructor.getBean(), beanEquals(constructor.getBean()));
    }

    @Step("Проверяем поля конструктора на тематических площадках")
    public void shouldSeeContextConstructorParameters(IBeanWrapper<ContextConstructor> constructor) {
        AllureUtils.addJsonAttachment("Ожидаемые параметры конструктора", constructor.toString());
        onConstructorForm().checkContextParameters(constructor.getBean(), beanEquals(constructor.getBean()));
    }

    @Step("Кликаем ок в конструкторе")
    public void setConstructorPrice() {
        try {
            onConstructorForm().clickOk();
            Thread.sleep(8000);
        } catch (Exception e) {
            throw new DirectWebError("Ошибка при сохранении ставки");
        }
    }

    @Step("Проверяем наличие алерта при установке цены")
    public void shouldSeeAlertWhenSetConstructorPrice(Matcher<String> matcher) {
        onConstructorForm().clickOk();
        AlertSteps.getInstance(AlertSteps.class, config).accept(matcher);
    }

    @Step("Проверяем наличие алерта при установке цены")
    public void shouldSeeAlertWithCloseWhenSetConstructorPrice(Matcher<String> matcher) {
        onConstructorForm().clickOk();
        AlertSteps.getInstance(AlertSteps.class, config).checkAlertAndDecline(matcher);
    }

    @Step("Закрываем конструктор ставок")
    public void closeConstructor() {
        onConstructorForm().clickCancel();
    }

    @Step("Открываем форму офлайн конструктора {0}")
    public void openOfflineConstructorByForm(OfflineConstructorForm form) {
        onConstructorForm().openConstructorOfflineByForm(form);
    }
}
