package ru.yandex.autotests.direct.web.steps.campaigns.retargeting;

import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.web.objects.retargeting.RetargetingConditionWeb;
import ru.yandex.autotests.direct.web.pages.retargeting.ShowRetargetingCondPage;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.direct.web.util.matchers.IsDisplayedMatcher.isDisplayed;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class ShowRetargetingCondPageSteps extends BaseSteps {

    private ShowRetargetingCondPage onShowRetargetingCondPage() {
        return ShowRetargetingCondPage.getInstance(ShowRetargetingCondPage.class, config);
    }

    @Step("Проверяем соответствие списока условий ретаргетинга условию {0}")
    public void retargetingConditionsListShould(org.hamcrest.Matcher matcher) {
        assertThat("спосок условий ретаргетинга неверный",
                onShowRetargetingCondPage().getRetargetingConditionsList(), matcher);
    }

    @Step("Добавляем условие ретаргетинга")
    public void addCondition(IBeanWrapper<RetargetingConditionWeb> condition) {
        AllureUtils.addJsonAttachment("Параметры условия", condition.toString());
        onShowRetargetingCondPage().clickAddConditionButton();
        onShowRetargetingCondPage().fillConditionParameters(condition.getBean());
        onShowRetargetingCondPage().clickSaveCondition();
        onShowRetargetingCondPage().checkEditPopup(not(isDisplayed()));
    }

    @Step("Добавляем условие ретаргетинга, и проверяем ошибку в попапе")
    public void addConditionWithErrorAndCheck(IBeanWrapper<RetargetingConditionWeb> condition, String errorText) {
        AllureUtils.addJsonAttachment("Параметры условия", condition.toString());
        onShowRetargetingCondPage().clickAddConditionButton();
        onShowRetargetingCondPage().fillConditionParameters(condition.getBean());
        onShowRetargetingCondPage().clickSaveCondition();
        onShowRetargetingCondPage().checkError(errorText);
    }

    @Step("Редактируем условие ретаргетинга {0}")
    public void editCondition(String name, IBeanWrapper<RetargetingConditionWeb> condition) {
        AllureUtils.addJsonAttachment("Параметры условия", condition.toString());
        onShowRetargetingCondPage().openCondition(name);
        onShowRetargetingCondPage().fillConditionParameters(condition.getBean());
        onShowRetargetingCondPage().clickSaveCondition();
        onShowRetargetingCondPage().checkEditPopup(not(isDisplayed()));
    }

    @Step("Редактируем условие ретаргетинга {0} и сохраняем как новое")
    public void editConditionAndSaveAsNew(String name, IBeanWrapper<RetargetingConditionWeb> condition) {
        AllureUtils.addJsonAttachment("Параметры условия", condition.toString());
        onShowRetargetingCondPage().openCondition(name);
        onShowRetargetingCondPage().fillConditionParameters(condition.getBean());
        onShowRetargetingCondPage().clickSaveConditionAsNew();
        onShowRetargetingCondPage().checkEditPopup(not(isDisplayed()));
    }

    @Step("Проверяем условие ретаргетинга")
    public void shouldSeeConditionParameters(IBeanWrapper<RetargetingConditionWeb> condition) {
        AllureUtils.addJsonAttachment("Параметры условия", condition.toString());
        onShowRetargetingCondPage().checkRetargetingCondition(condition.getBean());
    }

    @Step("Удаляем условие ретаргетинга {0}")
    public void deleteCondition(String conditionName) {
        onShowRetargetingCondPage().clickDeleteCondition(conditionName);
    }

    @Step("Открываем попап добавления условия ретаргетинга")
    public void openPopupAddNewConditon() {
        onShowRetargetingCondPage().clickAddConditionButton();
    }

    @Step("Открываем попап предупреждение для неправильно работающего условия ")
    public void openPopupWrongWorkingCondition(String conditionName) {
        onShowRetargetingCondPage().openWrongWorkingCondition(conditionName);
    }

    @Step("Открываем условие ретаргетинга {0}")
    public void openCondition(String name) {
        onShowRetargetingCondPage().openCondition(name);
    }

    public void showAnotherCamps(String nameCondition) {
        onShowRetargetingCondPage().showAnotherCamps(nameCondition);
    }
}
