package ru.yandex.autotests.direct.web.steps.campaigns.strategy;

import java.util.concurrent.TimeUnit;

import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.utils.strategy.objects.StrategyInfoWeb;
import ru.yandex.autotests.direct.web.objects.strategies.cpm.CpmStrategyInfoWeb;
import ru.yandex.autotests.direct.web.pages.campaigns.strategy.IStrategyBlock;
import ru.yandex.autotests.direct.web.pages.campaigns.strategy.IStrategyBlockProvider;
import ru.yandex.autotests.direct.web.pages.showcampbem.blocks.strategy.CpmStrategyBlock;
import ru.yandex.autotests.direct.web.pages.showcampbem.blocks.strategy.StrategyBemBlock;
import ru.yandex.autotests.direct.web.util.beanutils.BeanHelper;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.anyOf;
import static org.hamcrest.core.IsNot.not;
import static ru.yandex.autotests.direct.utils.beans.BeanWrapper.wrap;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.should;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.timeoutHasExpired;
import static ru.yandex.qatools.htmlelements.matchers.WebElementMatchers.exists;
import static ru.yandex.qatools.htmlelements.matchers.WebElementMatchers.isDisplayed;

/**
 * Created with IntelliJ IDEA.
 * User: alexey-n
 * Date: 07.11.13
 * Time: 14:17
 * To change this template use File | Settings | File Templates.
 */
public class StrategySteps extends BaseSteps {
    private IStrategyBlockProvider pageWithStrategyBlock;

    public void forPage(IStrategyBlockProvider pageWithStrategyBlock) {
        this.pageWithStrategyBlock = pageWithStrategyBlock;
    }

    private IStrategyBlock onStrategyBlock(Class<? extends StrategyBemBlock> strategyBemBlock) {
        return pageWithStrategyBlock.getStrategyBlock(strategyBemBlock);
    }

    /**
     * TODO: выпилить, оставлено для обратной совместимости со старыми стратегиями
     */
    private IStrategyBlock onStrategyBlock() {
        return onStrategyBlock(StrategyBemBlock.class);
    }

    @Step("Заполняем стратегию кампании")
    public void fillCampaignStrategy(IBeanWrapper<StrategyInfoWeb> wrapped) {
        AllureUtils.addJsonAttachment("Параметры стратегии", wrapped.toString());
        AllureUtils.addJsonAttachment("Параметры контекстной стратегии", wrapped.toString());
        pageWithStrategyBlock.openStrategyBlock();
        onStrategyBlock(mapStrategyToStrategyBlockClass(wrapped.getBean())).fillStrategy(wrapped.getBean());
        takeScreenshot();
    }


    @Step("Заполняем стратегию кампании и сохраняем изменения с ожиданием закрытия попапа")
    public void fillCampaignStrategyAndSave(IBeanWrapper<StrategyInfoWeb> wrapped) {
        fillCampaignStrategy(wrapped);
        onStrategyBlock().saveForm();
        waitForElement(onStrategyBlock().getStrategyBlock(), 5, not(isDisplayed()));
        takeScreenshot();
    }

    @Step("Заполняем стратегию кампании и сохраняем изменения с ожиданием появления алерта")
    public void fillCampaignStrategyAndWaitAlert(IBeanWrapper<StrategyInfoWeb> wrapped) {
        fillCampaignStrategy(wrapped);
        onStrategyBlock().saveForm();
        waitForElement(onStrategyBlock().getStrategyBlock(), 5, isDisplayed());
        takeScreenshot();
    }

    @Step("Заполняем параметры дневного бюджета и сохраняем изменения")
    public void fillDayBudgetAndSave(IBeanWrapper<StrategyInfoWeb> strategyInfoWebWrapped) {
        fillDayBudget(strategyInfoWebWrapped);
        onStrategyBlock().saveForm();
        waitForElement(onStrategyBlock().getStrategyBlock(), 5, not(isDisplayed()));
    }

    @Step("Заполняем параметры дневного бюджета и сохраняем изменения, ожидая ошибку")
    public void fillDayBudgetAndWaitAlert(IBeanWrapper<StrategyInfoWeb> strategyInfoWebWrapped) {
        fillDayBudget(strategyInfoWebWrapped);
        onStrategyBlock().saveForm();
        waitForElement(onStrategyBlock().getStrategyBlock(), 3, isDisplayed());
    }

    @Step("Заполняем параметры дневного бюджета")
    public void fillDayBudget(IBeanWrapper<StrategyInfoWeb> strategyInfoWeWrapped) {
        pageWithStrategyBlock.openStrategyBlock();
        AllureUtils.addJsonAttachment("Параметры дневного бюджета", wrap(strategyInfoWeWrapped).toString());
        onStrategyBlock().fillDayBudget(strategyInfoWeWrapped.getBean());
    }

    @Step("Проверяем параметры дневного бюджета")
    public void shouldSeeDayBudget(IBeanWrapper<StrategyInfoWeb> expectedBean) {
        shouldSeeStrategyPopupBlock(not(isDisplayed()));
        pageWithStrategyBlock.openStrategyBlock();
        StrategyInfoWeb strategyInfoWeb = BeanHelper.getOnlyFields(expectedBean.getBean(),
                "dayBudgetSum", "dayBudgetShowMode");
        AllureUtils.addJsonAttachment("Параметры дневного бюджета", wrap(strategyInfoWeb).toString());
        onStrategyBlock().checkDayBudget(expectedBean.getBean());
    }

    @Step("Проверяем, что параметры стратегии соответствуют {0}")
    public void shouldSeeStrategy(IBeanWrapper<StrategyInfoWeb> expectedBean) {
        AllureUtils.addJsonAttachment("Параметры стратегии", expectedBean.toString());
        pageWithStrategyBlock.openStrategyBlock();
        takeScreenshot();
        onStrategyBlock(mapStrategyToStrategyBlockClass(expectedBean.getBean())).checkStrategy(expectedBean.getBean());
    }

    @Step("Проверяем, что блок стратегии {0}")
    public void shouldSeeStrategyPopupBlock(Matcher matcher) {
        assertThat("блок стратегии не соответствует ожиданиям",
                onStrategyBlock(), should(matcher)
                        .whileWaitingUntil(timeoutHasExpired(TimeUnit.SECONDS.toMillis(5))));
    }

    @Step("Провеняем, что блок дневного бюджета {0}")
    public void shouldSeeDayBudgetBlock(Matcher matcher) {
        if (!isDisplayed().matches(onStrategyBlock())) {
            pageWithStrategyBlock.openStrategyBlock();
        }
        onStrategyBlock().checkDayBudgetBlock(matcher);
        onStrategyBlock().saveForm();
    }

    @Step("Провеняем, что блок дневного бюджета закрылся")
    public void shouldNotSeeDayBudgetBlock() {
        onStrategyBlock().checkDayBudgetBlock(anyOf(not(exists()), not(isDisplayed())));
    }

    @Step("Провеняем, что алерт в блоке дневного бюджета {0}")
    public void shouldSeeAlertOnDayBudgetBlock(Matcher<String> matcher) {
        onStrategyBlock().checkDayBudgetAlert(matcher);
    }

    @Step("Провеняем текст ошибки в блоке дневного бюджета {0}")
    public void checkErrorTextInBlock(Matcher<String> matcher) {
        onStrategyBlock().checkErrorText(matcher);
    }

    @Step("Открываем попап параметров стратегии")
    public void openStrategyPopup() {
        pageWithStrategyBlock.openStrategyBlock();
    }

    private Class<? extends StrategyBemBlock> mapStrategyToStrategyBlockClass(StrategyInfoWeb strategyInfoWeb) {
        Class<? extends StrategyBemBlock> strategyPopupClass;
        return strategyInfoWeb instanceof CpmStrategyInfoWeb ? CpmStrategyBlock.class : StrategyBemBlock.class;
    }
}
