package ru.yandex.autotests.direct.web.steps.clients;

import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.pages.clients.CreateLoginPage;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

/**
 * Created with IntelliJ IDEA.
 * User: alex-samo
 * Date: 11.11.13
 * Time: 10:09
 * To change this template use File | Settings | File Templates.
 */
public class CreateLoginPageSteps extends BaseSteps {


    private CreateLoginPage onCreateLoginPage() {
        return CreateLoginPage.getInstance(CreateLoginPage.class, config);
    }

    @Step("Регистрируем новый логин")
    public void registerNewLogin(IBeanWrapper<AccountWeb> accountWeb) {
        AllureUtils.addTextAttachment("Аккаунт", accountWeb.toString());
        onCreateLoginPage().fillParameters(accountWeb.getBean());
        onCreateLoginPage().clickOnRegisterButton();
    }
}
