package ru.yandex.autotests.direct.web.steps.clients;

import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.pages.superpages.ModifyUserPage;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;


public class ModifyUserPageSteps extends BaseSteps {

    private ModifyUserPage onModifyUserPage() {
        return ModifyUserPage.getInstance(ModifyUserPage.class, config);
    }

    @Step
    public void clickOnContinueButton() {
        onModifyUserPage().clickOnContinueButton();
    }

    @Step
    public void submitUserEditForm() {
        onModifyUserPage().clickOnSaveButton();
    }

    @Step
    public void selectShowFirstHelpTizerCheckBox() {
        onModifyUserPage().selectShowFirstHelpTizerCheckBox();
    }

    @Step("Проверяем, что значение поля Страна соответствует {0}")
    public void shouldSeeCountryText(Matcher matcher) {
        onModifyUserPage().checkCountryText(matcher);
    }

    @Step("Проверяем, что значение поля Валюта оплаты соответствет {0}")
    public void shouldSeeCurrencyText(Matcher matcher) {
        onModifyUserPage().checkCurrencyText(matcher);
    }

    @Step
    public void setEditCampaign(Boolean state) {
        onModifyUserPage().setEditCampaignCheckBox(state);
    }

    @Step
    public void setTransferFunds(Boolean state) {
        onModifyUserPage().setTransferFundsCheckBox(state);
    }

    @Step
    public void setManageCampaignsInExcel(Boolean state) {
        onModifyUserPage().setManageCampaignsInExcelCheckBox(state);
    }

    @Step("Заполняем параметры аккаунта")
    public void fillParameters
            (IBeanWrapper<AccountWeb> newAccountWeb)
    {
        AllureUtils.addJsonAttachment("Параметры аккаунта", newAccountWeb.toString());
        onModifyUserPage().fillParameters(newAccountWeb.getBean());
    }

    @Step("Сохраняем пользователя")
    public void saveUser() {
        onModifyUserPage().clickOnSaveButton();
    }

    @Step("Проверяем параметры аккаунта")
    public void shouldSeeParameters(IBeanWrapper<AccountWeb> accountWeb) {
        AllureUtils.addJsonAttachment("Параметры аккаунта", accountWeb.toString());
        onModifyUserPage().checkParameters(accountWeb.getBean());
    }
}