package ru.yandex.autotests.direct.web.steps.clients;

import java.util.List;

import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.web.data.SubClientAction;
import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.pages.clients.ShowClientsPage;
import ru.yandex.autotests.direct.web.pages.clients.UnArchiveUserPage;
import ru.yandex.autotests.direct.web.steps.AlertSteps;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import static ru.yandex.autotests.direct.utils.beans.BeanWrapper.wrap;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanHelper.getOnlyFields;
import static ru.yandex.qatools.allure.webdriver.pages.BasePageObject.withParameters;

/**
 * User: buhter
 * Date: 26.02.13
 * Time: 18:15
 */
public class ShowClientsSteps extends BaseSteps {

    public AlertSteps alert() {
        return BaseSteps.getInstance(AlertSteps.class, config);
    }

    public UnArchiveUserPage onUnArchiveUserPage() {
        return UnArchiveUserPage.getInstance(UnArchiveUserPage.class, config);
    }

    private ShowClientsPage onShowClientsPage() {
        return ShowClientsPage.getInstance(ShowClientsPage.class, config);
    }

    @Step("Проверяем клиента")
    public void shouldSeeClient(IBeanWrapper<AccountWeb> account) {
        AllureUtils.addJsonAttachment("Аккаунт", account.toString());
        onShowClientsPage().checkAccount(account.getBean());
    }

    public void shouldSeeClientParameters(IBeanWrapper<AccountWeb> account, String... fields) {
        AccountWeb expectedAccount = getOnlyFields(account.getBean(), fields);
        shouldSeeClient(wrap(expectedAccount));
    }

    @Step("Ищем клиента {0}")
    public void searchForClient(String login) {
        onShowClientsPage().fillSearchInput(login);
    }

    @Step("Открываем кампании клиента {0}")
    public void openClientsCampaignsList(String clientName) {
        onShowClientsPage().clickOnClient(clientName);
    }

    @Step("Открываем страницу редактирования клиента {0}")
    public void openEditClientPage(String clientLogin) {
        onShowClientsPage().openEditClientPage(clientLogin);
    }

    @Step("Архивируем клиента {0} и проверяем, что алерт удовлетворяет условию {1}")
    public void archiveClientAndCheckForAlert(String clientLogin, Matcher<String> matcher) {
        onShowClientsPage().clickOnArchiveClientLink(clientLogin);
        alert().accept(matcher);
    }

    @Step("Разархивируем клиента {0} и проверяем, что алерт удовлетворяет условию {1}")
    public void unArchiveClientAndCheckForAlert(String clientLogin, Matcher<String> matcher) {
        onShowClientsPage().clickOnUnArchiveClientLink(clientLogin);
        alert().accept(matcher);
    }

    @Step("Проверяем, что сноска клиента {0} удовлетворяет условию {1}")
    public void shouldSeeClientAuthorizationFootnoteText(String clientLogin, Matcher matcher) {
        onShowClientsPage().checkClientAuthorizationFootnoteText(clientLogin, matcher);
    }

    @Step("Проверяем, что логин главного представителя агентства удовлетворяет условию {0}")
    public void shouldSeeSeniorAgencyRepresentativeLogin(Matcher matcher) {
        onShowClientsPage().checkSeniorAgencyRepresentative(matcher);
    }

    @Step("Проверяем, что список логинов клиентов удовлетворяет условию {0}")
    public void shouldSeeClientLogins(Matcher<List<String>> matcher) {
        onShowClientsPage().checkClientsListLogins(matcher);
    }

    @Step("Устанавливем чекбокс клиента {0} в состояние {1}")
    public void setClientCheckBox(String clientLogin, Boolean state) {
        onShowClientsPage().setClientCheckBox(clientLogin, state);
    }

    @Step("Выполняем действие субклиента {0}")
    public void doSubClientAction(SubClientAction subClientAction) {
        onShowClientsPage().selectAction(subClientAction);
        onShowClientsPage().clickOnApplyButton();
    }

    @Step("Разархивиуем клиентов {0}")
    public void unArchiveAClients(String... logins) {
        for (String login : logins) {
            onUnArchiveUserPage().open("unarchive.client", withParameters(login));
            onUnArchiveUserPage().clickOnSubmitButton();
        }
    }

    @Step("Разархивируем всех клиентов")
    public void unArchiveAllClients() {
        List<String> logins = onShowClientsPage().getVisibleLogins();
        unArchiveAClients(logins.toArray(new String[logins.size()]));
    }
}
