package ru.yandex.autotests.direct.web.steps.clients;

import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.web.pages.clients.ShowManagerMyClientsPage;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

/**
 * Created with IntelliJ IDEA.
 * User: alex-samo
 * Date: 08.11.13
 * Time: 16:32
 * To change this template use File | Settings | File Templates.
 */
public class ShowManagerMyClientsPageSteps extends BaseSteps {


    private ShowManagerMyClientsPage onShowManagerMyClientsPage() {
        return ShowManagerMyClientsPage.getInstance(ShowManagerMyClientsPage.class, config);
    }

    @Step("Ищем клиента {0}")
    public void searchFor(String query) {
        onShowManagerMyClientsPage().fillSearchInput(query);
    }

    @Step("Проверяем, что список логинов агентсв удовлетворяет условию {0}")
    public void shouldSeeAgencyLoginsList(Matcher<Iterable<? super String>> matcher) {
        onShowManagerMyClientsPage().checkVisibleAgencyLoginsList(matcher);
    }

    @Step("Проверяем, что список логинов клиентов удовлетворяет условию {0}")
    public void shouldSeeClientLoginsList(Matcher<Iterable<? super String>> matcher) {
        onShowManagerMyClientsPage().checkVisibleClientLoginsList(matcher);
    }
}
