package ru.yandex.autotests.direct.web.steps.clients;

import ru.yandex.autotests.direct.web.pages.clients.StepZeroPage;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class StepZeroPageSteps extends BaseSteps {

    private StepZeroPage onStepZeroPage() {
        return StepZeroPage.getInstance(StepZeroPage.class, config);
    }

    @Step("Выбираем логин {0}")
    public void ChooseLogin(String login) {
        onStepZeroPage().inputLogin(login);
        onStepZeroPage().clickNext();
    }

    @Step("Открываем страницу создания логина")
    public void openCreateLoginPage() {
        onStepZeroPage().clickOnRegisterNewClientLoginLink();
        onStepZeroPage().openPopupInNewWindow();
    }
}
