package ru.yandex.autotests.direct.web.steps.clients;

import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.pages.clients.StepZeroProcessPage;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class StepZeroProcessPageSteps extends BaseSteps {

    private StepZeroProcessPage onStepZeroProcessPage() {
        return StepZeroProcessPage.getInstance(StepZeroProcessPage.class, config);
    }

    @Step("Сохраняем параметры аккаунта")
    public void saveAccountParameters(IBeanWrapper<AccountWeb> account) {
        AllureUtils.addJsonAttachment("Аккаунт", account.toString());
        onStepZeroProcessPage().fillParameters(account.getBean());
        onStepZeroProcessPage().clickSave();
    }
}
