package ru.yandex.autotests.direct.web.steps.clients;

import java.util.List;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;

import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.pages.users.UserSettingsPage;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.annotations.WithoutScreenshot;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.qatools.allure.webdriver.pages.BasePageObject.withParameters;


public class UserSettingsPageSteps extends BaseSteps {

    @Step
    public void openUserSettingsPage(String login) {
        UserSettingsPage.getInstance(UserSettingsPage.class, config).open("user.settings", withParameters(login));
    }

    @Step
    public void openUserSettingsPage() {
        UserSettingsPage.getInstance(UserSettingsPage.class, config).open("self.settings", withParameters());
    }

    @Step
    public void submitUserSettings() {
        onUserSettingsPage().clickSaveButton();
    }

    private UserSettingsPage onUserSettingsPage() {
        return UserSettingsPage.getInstance(UserSettingsPage.class, config);
    }

    @Step
    public void checkUserFio(Matcher matcher) {
        String actualFIO = onUserSettingsPage().getClientFIOInput().getWrappedElement().getAttribute("value");
        assertThat("проверка значения поля ФИО", actualFIO, matcher);
    }

    @Step
    public void openAddEmailPage() {
        onUserSettingsPage().clickOnAddNewEmailButton();
    }

    @Step
    @WithoutScreenshot
    public void addNewEmail(String email) {
        onUserSettingsPage().fillEmailTextInput(email);
        takeScreenshot();
        onUserSettingsPage().clickOnSaveEmailButton();
    }

    @Step
    public void fillParameters(AccountWeb newAccountWeb) {
        onUserSettingsPage().fillParameters(newAccountWeb);
    }

    @Step
    public void fillParameters(IBeanWrapper<AccountWeb> newAccountWeb) {
        this.onUserSettingsPage().fillParameters((AccountWeb) newAccountWeb.getBean());
    }

    @Step
    public void fillMetrikaCountersSaveAndCheckNotVisible(List<Long> metrikaCounters) {
        onUserSettingsPage().fillMetrikaCountersSaveAndCheckNotVisible(metrikaCounters);
    }

    @Step
    public void fillMetrikaCountersSaveAndCheckVisible(List<Long> metrikaCounters) {
        onUserSettingsPage().fillMetrikaCountersSaveAndCheckVisible(metrikaCounters);
    }

    @Step
    public void fillMetrikaCounters(String metrikaCounters) {
        onUserSettingsPage().fillMetrikaCounters(metrikaCounters);
    }

    @Step
    public void fillMetrikaCounters(List<Long> metrikaCounters) {
        onUserSettingsPage().fillMetrikaCounters(metrikaCounters);
    }

    @Step
    public void shouldSeeMetrikaCountersValidationMessage(Matcher<WebElement> checkMatcher) {
        onUserSettingsPage().checkMetrikaValidationMessage(checkMatcher);
    }

    @Step
    public void shouldSeeParameters(IBeanWrapper<AccountWeb> clientRepresentativeAccountWeb) {
        onUserSettingsPage().checkParameters(clientRepresentativeAccountWeb.getBean());
    }
}