package ru.yandex.autotests.direct.web.steps.clients;

import ru.yandex.autotests.direct.web.pages.users.UserUploadDocumentsPage;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import static org.hamcrest.CoreMatchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

public class UserUploadDocumentsPageSteps extends BaseSteps {

    private UserUploadDocumentsPage onUserLoadDocumentsPagePage() {
        return UserUploadDocumentsPage.getInstance(UserUploadDocumentsPage.class, config);
    }

    private String SUCCESS_MESSAGE = "Спасибо, Ваши документы успешно отправлены.";

    @Step("Заполняем все поля на странице")
    public void fillValues(String email, String campaignId, String fileName, String comment) {
        onUserLoadDocumentsPagePage().setEmail(email);
        onUserLoadDocumentsPagePage().uploadFile(fileName);
        onUserLoadDocumentsPagePage().setComment(comment);
        onUserLoadDocumentsPagePage().setCampaignId(campaignId);
        takeScreenshot();
    }

    public void submit() {
        onUserLoadDocumentsPagePage().clickSend();
    }

    public void checkSuccess() {
        takeScreenshot();
        assertThat("сообщение об успехе загрузки отображается корректно",
                onUserLoadDocumentsPagePage().getUploadMessage(),
                equalTo(SUCCESS_MESSAGE));
    }
}