package ru.yandex.autotests.direct.web.steps.clients;

import java.util.List;
import java.util.stream.Collectors;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;

import ru.yandex.autotests.direct.web.data.CampaignTypeEnum;
import ru.yandex.autotests.direct.web.pages.clients.WelcomePage;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import static org.hamcrest.MatcherAssert.assertThat;

public class WelcomePageSteps extends BaseSteps {

    private WelcomePage onWelcomePage() {
        return WelcomePage.getInstance(WelcomePage.class, config);
    }

    @Step("Заполняем email:{0} и переходим далее")
    public void fillEmail(String email) {
        onWelcomePage().fillEmail(email);
    }

    @Step("Выбираем страну: {0}")
    public void selectCountry(String country) {
        onWelcomePage().selectCountry(country);
    }

    @Step("Выбираем валюту {0}")
    public void selectCurrency(String currency) {
        onWelcomePage().selectCurrency(currency);
    }

    @Step("Принимаем оферту об обработке данных")
    public void acceptAgreement() {
        onWelcomePage().setAcceptAgreementCheckboxState(true);
    }

    @Step("Кликаем 'Начать пользоваться сервисом'")
    public void startUsingService() {
        onWelcomePage().getStartToUseServiceButton().click();
    }

    @Step("Начинаем пользоваться сервисом и проверяем алерт: {0}")
    public void startUsingServiceAndShouldSeeBrowserAlert() {
        onWelcomePage().setAcceptAgreementCheckboxState(true);
        onWelcomePage().startToUseServiceButtonShouldBeEnabled();
    }

    @Step("Проверяем, что валюта в списке удовлетворяет условию {0}")
    public void shouldSeeCurrencyOnList(Matcher matcher) {
        List<WebElement> options = onWelcomePage().getCurrencyList();
        assertThat(options.stream().map(WebElement::getText).collect(Collectors.toList()), matcher);
    }

    @Step("Выбираем тип кампании")
    public void chooseTypeCampaign(CampaignTypeEnum campaignTypeEnum) {
        onWelcomePage().clickAddCampaign(campaignTypeEnum);
    }
}
