package ru.yandex.autotests.direct.web.steps.excel;

import ru.yandex.autotests.direct.web.pages.excel.ImportCampXlsPage;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 02.08.14
 */
public class ImportCampXlsPageSteps extends BaseSteps {

    private ImportCampXlsPage onImportCampXlsPage() {
        return ImportCampXlsPage.getInstance(ImportCampXlsPage.class, config);
    }

    @Step("Принимаем условия оферты")
    public void acceptOferta() {
        onImportCampXlsPage().acceptOferta();
    }

    @Step("Нажимаем 'принять'")
    public void accept() {
        onImportCampXlsPage().clickOnAcceptButton();
    }

    @Step("Нажимаем 'Выбрать файл'")
    public void chooseFile() {
        onImportCampXlsPage().clickOnChooseFileButton();
    }
}
