package ru.yandex.autotests.direct.web.steps.excel;

import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.web.pages.excel.ShowExportedXlsListPage;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 02.08.14
 */
public class ShowExportedXlsListPageSteps extends BaseSteps {

    private ShowExportedXlsListPage onShowExportedXlsListPage() {
        return ShowExportedXlsListPage.getInstance(ShowExportedXlsListPage.class, config);
    }

    @Step("Загружаем кампанию из excel файла {0}")
    public void uploadCampaignFromExcelFile(String fileName) {
        onShowExportedXlsListPage().uploadFile(fileName);
    }

    @Step("Загружаем кампанию из csv файла {0}")
    public void uploadCampaignFromCsvFile(String fileName) {
        onShowExportedXlsListPage().uploadCSVFile(fileName);
    }

    @Step("Проверяем, что список ошибок загрузки excel файла удовлетворяет условию {0}")
    public void shouldSeeUploadErrors(Matcher matcher) {
        onShowExportedXlsListPage().checkUploadErrors(matcher);
    }
}
