package ru.yandex.autotests.direct.web.steps.feeds;

import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.web.objects.feeds.FeedWeb;
import ru.yandex.autotests.direct.web.pages.feeds.ShowFeedsPage;
import ru.yandex.autotests.direct.web.steps.CommonSteps;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import java.util.List;

import static ru.yandex.autotests.direct.utils.beans.BeanWrapper.wrap;

/**
 * Created by aleran on 08.09.2015.
 */
public class ShowFeedsSteps extends BaseSteps {

    public CommonSteps inOperatingSystem() {
        return BaseSteps.getInstance(CommonSteps.class, config);
    }

    private ShowFeedsPage onShowFeedsPage() {
        return ShowFeedsPage.getInstance(ShowFeedsPage.class, config);
    }

    @Step("Удаление фидов")
    public void deleteFeeds(List<Long> feedIds){
        AllureUtils.addJsonAttachment("Параметры фида", wrap(feedIds).toString());
        onShowFeedsPage().deleteFeeds(feedIds);
    }

    @Step("Удаление фида с ид = {0}")
    public void deleteFeed(Long feedId){
        onShowFeedsPage().deleteFeed(feedId);
    }

    @Step("Открываем попап добавления фида")
    public void clickAddFeedButton(){
        onShowFeedsPage().clickAddFeedButton();
    }

    @Step("Заполняем фид")
     public void fillFeedParameters(IBeanWrapper<FeedWeb> feed){
        AllureUtils.addJsonAttachment("Параметры фида", feed.toString());
        onShowFeedsPage().fillFeedParameters(feed.getBean());
        clickSaveFeedButton();
    }

    @Step("Открывает фид {0} на редактирование")
    public void clickEditFeedButton(String feedId){
        onShowFeedsPage().clickEditFeedButton(feedId);
    }

    @Step("Получаем последний измененный фид")
    public String getNewFeedRowId(){
        return onShowFeedsPage().getNewFeedRowId();
    }

    @Step("Нажимаем кнопку сохранить фид")
    public void clickSaveFeedButton(){
        onShowFeedsPage().clickSaveFeedButton();
    }

    @Step("Проверяем параметры фида")
    public void checkFeedParameters(IBeanWrapper<FeedWeb> feed){
        AllureUtils.addJsonAttachment("Параметры фида", feed.toString());
        onShowFeedsPage().checkFeedParameters(feed.getBean());
    }

    @Step("Проверяем отсутствие фидов")
    public void checkDeletedFeedsNotExist(IBeanWrapper<List<String>> feed){
        AllureUtils.addJsonAttachment("Параметры фида", feed.toString());
        onShowFeedsPage().checkDeletedFeedsNotExist(feed.getBean());
    }

    @Step("Проверяем кампании в фиде {0}")
    public void shouldSeeCampaignIds(String feedId, List<Long> campaignIds) {
        AllureUtils.addJsonAttachment("id кампаний", wrap(campaignIds).toString());
        onShowFeedsPage().shouldSeeCampaignIds(feedId, campaignIds);
    }

    @Step("Проверяем кампанию {1} в фиде {0}")
    public void shouldSeeCampaignId(String feedId, Long campaignId) {
        onShowFeedsPage().shouldSeeCampaignId(feedId, campaignId);
    }

}
