package ru.yandex.autotests.direct.web.steps.firsthelp;

import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.web.objects.campaigns.HelpRequestInfo;
import ru.yandex.autotests.direct.web.pages.superpages.optimizecampaigns.ListOptimizePage;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

public class ListOptimizePageSteps extends BaseSteps {

    private ListOptimizePage onListOptimizePage() {
        return ListOptimizePage.getInstance(ListOptimizePage.class, config);
    }

    @Step("Проверяем, что параметры запроса на Первую помощь соответствуют ожидаемым")
    public void shouldSeeHelpRequestParameters(IBeanWrapper<HelpRequestInfo> expectedBean) {
        AllureUtils.addJsonAttachment("Параметры запроса ", expectedBean.toString());
        onListOptimizePage().checkHelpRequestParameters(expectedBean.getBean());
    }
}
