package ru.yandex.autotests.direct.web.steps.firsthelp;

import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.web.pages.firsthelp.ViewOptimizingCommentPage;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import static org.hamcrest.MatcherAssert.assertThat;

/**
 * @author: Alex Samokhin (alex-samo@yandex-team.ru)
 * Date: 05.12.13
 */
public class ViewOptimizingCommentPageSteps extends BaseSteps {


    private ViewOptimizingCommentPage onViewOptimizingCommentPage() {
        return ViewOptimizingCommentPage.getInstance(ViewOptimizingCommentPage.class, config);
    }

    @Step("Проверяем, что комментарий к оптимизации удовлетворяет условию: {0}")
    public void shouldSeeOptimizingComment(Matcher matcher) {
        assertThat(onViewOptimizingCommentPage().getOptimizingCommentText(), matcher);
    }
}
