package ru.yandex.autotests.direct.web.steps.managers;


import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;

import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.pages.managers.AdmShowAddAgencyPage;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.annotations.WithoutScreenshot;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import static ru.yandex.autotests.direct.utils.beans.BeanWrapper.wrap;

/**
 * @author: Alex Samokhin (alex-samo@yandex-team.ru)
 * Date: 17.11.13
 */
public class AdmShowAddAgencyPageSteps extends BaseSteps {


    private AdmShowAddAgencyPage onAdmShowAddAgencyPage() {
        return AdmShowAddAgencyPage.getInstance(AdmShowAddAgencyPage.class, config);
    }

    @Step("Заполняем параметры агентства ")
    public void fillAgency(AccountWeb agencyAccountWeb) {
        AllureUtils.addJsonAttachment("Агентство", wrap(agencyAccountWeb).toString());
        onAdmShowAddAgencyPage().fillParameters(agencyAccountWeb);
    }

    @Step("Кликаем по кнопке 'Найти агентство'")
    @WithoutScreenshot
    public void findAgency() {
        onAdmShowAddAgencyPage().clickOnFindButton();
    }

    @Step("Ожидаем сообщение соответсвующее ожиданию: {0}")
    public void shouldSeeMessage(Matcher<WebElement> matcher) {
        onAdmShowAddAgencyPage().shouldSeeMessage(matcher);
    }
}
