package ru.yandex.autotests.direct.web.steps.managers;

import org.hamcrest.Matcher;
import ru.yandex.autotests.direct.web.objects.campaigns.CopyCampaignInfoWeb;
import ru.yandex.autotests.direct.web.pages.managers.CopyCampPage;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.util.StringHelper;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import java.util.List;

import static com.google.common.collect.Iterables.getLast;
import static ru.yandex.autotests.direct.utils.beans.BeanWrapper.wrap;

/**
 * Author buhter
 * Date 27.05.14
 */
public class CopyCampPageSteps extends BaseSteps {

    private CopyCampPage onCopyCampPage() {
        return CopyCampPage.getInstance(CopyCampPage.class, config);
    }

    @Step("Заполняем форму копирования кампании ")
    public void fillForm(CopyCampaignInfoWeb copyCampaignInfoWeb) {
        AllureUtils.addJsonAttachment("Данные о копировании", wrap(copyCampaignInfoWeb).toString());
        onCopyCampPage().fillParameters(copyCampaignInfoWeb);
    }

    @Step("Кликаем по кнопке 'Скопировать'")
    public void copy() {
        onCopyCampPage().clickCopyButton();
    }

    @Step("Проверяем, что появился выбор типа обслуживания")
    public void shouldSeeServicingTypeSelectDislpayed() {
        onCopyCampPage().checkServicingTypeSelectDisplayed();
    }

    @Step("Выбираем типа обслуживания")
    public void selectServicingType(String value) {
        onCopyCampPage().selectServicingType(value);
        AllureUtils.addTextAttachment("Выбранный тип обслуживания", onCopyCampPage().getServicingTypeSelect().getFirstSelectedOption().getText());
    }

    @Step("Проверяем текст ошибки")
    public void shouldSeeError(Matcher<String> matcher) {
        AllureUtils.addTextAttachment("Текст ошибки", onCopyCampPage().getErrorText());
        onCopyCampPage().checkErrorText(matcher);
    }

    @Step("Проверяем текст предупреждения о несоответствии валют")
    public void shouldSeeCurrencyWarning(Matcher<String> matcher) {
        AllureUtils.addTextAttachment("Текст ошибки", onCopyCampPage().getCurrencyWarning());
        onCopyCampPage().checkCurrencyWarningText(matcher);
    }

    @Step("Проверяем, что появился текст успешного копирования")
    public void shouldSeeSuccessMessageDislpayed() {
        onCopyCampPage().checkSuccessMessageDisplayed();
    }

    @Step("Проверяем текст успешного копирования")
    public void checkSuccessMessage(Matcher<String> matcher) {
        AllureUtils.addTextAttachment("Текст успешного копирования", onCopyCampPage().getSuccessMessage());
        shouldSeeSuccessMessageDislpayed();
        onCopyCampPage().checkSuccessMessage(matcher);
    }

    @Step("Получаем id новой кампании из сообщения об успешном копировании")
    public Long getCopiedCampaignIdFromSuccessMessage() {
        List<Long> campaignsFromMessage = StringHelper.getNumericDataFromText(onCopyCampPage().getSuccessMessage());
        if (campaignsFromMessage.isEmpty()) {
            throw new DirectWebError("Не найдено кампаний в сообщении");
        }
        return getLast(campaignsFromMessage);
    }

    @Step("Копирование кампании проверка корректного сообщения об успешном копировании")
    public void copyCampaignAndCheckSuccessMessage(CopyCampaignInfoWeb copyCampaignInfoWeb, Matcher<String> matcher) {
        fillForm(copyCampaignInfoWeb);
        copy();
        checkSuccessMessage(matcher);
    }
}
