package ru.yandex.autotests.direct.web.steps.managers;

import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.web.pages.managers.CreateAgencyPage;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.AlertSteps;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

/**
 * @author: Alex Samokhin (alex-samo@yandex-team.ru)
 * Date: 17.11.13
 */
public class CreateAgencyPageSteps extends BaseSteps {


    private CreateAgencyPage onCreateAgencyPage() {
        return CreateAgencyPage.getInstance(CreateAgencyPage.class, config);
    }

    @Step("Кликаем по кнопке 'Создать агентство' и проверяем, что алерт удовлетворяет условию {0}")
    public void createAgencyAndCheckForAlert(Matcher<String> matcher) {
        onCreateAgencyPage().clickOnCreateButton();
        AlertSteps.getInstance(AlertSteps.class, config).accept(matcher);
    }
}
