package ru.yandex.autotests.direct.web.steps.mediaplan;

import java.util.List;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.web.data.priceconstructor.MediaplanTrafficVolume;
import ru.yandex.autotests.direct.web.objects.banners.OptimizedPhraseInfoWeb;
import ru.yandex.autotests.direct.web.pages.mediaplans.MultiEditMediaplanPage2;
import ru.yandex.autotests.direct.web.steps.CommonSteps;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import static org.hamcrest.Matchers.equalToIgnoringCase;
import static ru.yandex.autotests.direct.utils.beans.BeanWrapper.wrap;
import static ru.yandex.autotests.direct.web.util.helpers.campaigns.BannersHelper.getPhraseFields;
import static ru.yandex.autotests.direct.web.util.matchers.webdriver.HasURL.hasURL;

/**
 * User: alexey-n
 * Date: 12.09.13
 * Time: 11:03
 */
public class MultiEditMediaplanPage2Steps extends BaseSteps {

    private final static String EDIT = "Редактирование";


    private MultiEditMediaplanPage2 onMultiEditMediaplanPage2() {
        return MultiEditMediaplanPage2.getInstance(MultiEditMediaplanPage2.class, config);
    }

    public CommonSteps inOperatingSystem() {
        return BaseSteps.getInstance(CommonSteps.class, config);
    }

    public CommonSteps getCommonSteps() {
        return CommonSteps.getInstance(CommonSteps.class, config);
    }

    @Step("Получаем параметры фразы")
    public OptimizedPhraseInfoWeb getPhraseInfo(IBeanWrapper<OptimizedPhraseInfoWeb> expectedPhrase) {
        AllureUtils.addJsonAttachment("Параметры фразы для получения", expectedPhrase.toString());
        return onMultiEditMediaplanPage2().getPhraseInfo(expectedPhrase.getBean());
    }

    @Step("Заполняем фразу")
    public void fillPhraseParameters(IBeanWrapper<OptimizedPhraseInfoWeb> phrase) {
        AllureUtils.addJsonAttachment("Параметры фразы", phrase.toString());
        onMultiEditMediaplanPage2().fillPhraseParameters(phrase.getBean());
    }

    @Step("Откланяем фразу")
    public void declinePhrase(IBeanWrapper<OptimizedPhraseInfoWeb> phrase) {
        AllureUtils.addJsonAttachment("Параметры фразы", phrase.toString());
        onMultiEditMediaplanPage2().declinePhrase(phrase.getBean());
    }

    @Step("Проверяем фразу")
    public void shouldSeePhrase(IBeanWrapper<OptimizedPhraseInfoWeb> phraseInfo) {
        AllureUtils.addJsonAttachment("Ожидаемые параметры фразы", phraseInfo.toString());
        onMultiEditMediaplanPage2().checkPhraseParameters(phraseInfo.getBean());

    }

    @Step("Проверяем, что фразы нет в списке")
    public void shouldNotSeePhrase(IBeanWrapper<OptimizedPhraseInfoWeb> phraseInfo) {
        AllureUtils.addJsonAttachment("Параметры фразы", phraseInfo.toString());
        onMultiEditMediaplanPage2().checkPhraseNotVisible(phraseInfo.getBean());
    }

    //проверяет фразы на последнем шаге редактирования баннера.
    @Step("Проверяем список фраз")
    public void shouldSeePhraseList(List<OptimizedPhraseInfoWeb> phrasesInfo) {
        AllureUtils.addJsonAttachment("Список фраз", phrasesInfo.toString());
        for (OptimizedPhraseInfoWeb phraseInfoWeb : phrasesInfo) {
            shouldSeePhrase(wrap(phraseInfoWeb));
        }
    }

    public void shouldSeePhraseFields(OptimizedPhraseInfoWeb phraseInfo, String... fields) {
        OptimizedPhraseInfoWeb expectedPhrase = getPhraseFields(phraseInfo, fields);
        shouldSeePhrase(wrap(expectedPhrase));
    }

    @Step("Устанавливаем позицию фраз {0} через групповые действия")
    public void groupActionSetPhrasePrice(MediaplanTrafficVolume priceType) {
        switch (priceType) {
            case FIVE:
                onMultiEditMediaplanPage2().clickSetTrafficValue5();
                break;
            case HUNDRED:
                onMultiEditMediaplanPage2().clickSetTrafficValue100();
                break;
        }
    }

    @Step("Сохраняем медиаплан")
    public void saveMediaplan() {
        String currntURL = config.getDriver().getCurrentUrl();
        onMultiEditMediaplanPage2().clickSaveButton();
        getCommonSteps().shouldSeeBrowser(CoreMatchers.not(hasURL(equalToIgnoringCase(currntURL))));
    }

    @Step("Проверяем, что кнопка 'Сохраниь'")
    public void shouldSeeSaveButton(Matcher matcher) {
        onMultiEditMediaplanPage2().checkSaveButton(matcher);
    }

    @Step("Нажимаем 'Назад'")
    public void goBack() {
        String currntURL = config.getDriver().getCurrentUrl();
        onMultiEditMediaplanPage2().clickPrevButton();
        getCommonSteps().shouldSeeBrowser(CoreMatchers.not(hasURL(equalToIgnoringCase(currntURL))));
    }
}
