package ru.yandex.autotests.direct.web.steps.mediaplan;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.web.data.banners.GroupChangesBlockTabs;
import ru.yandex.autotests.direct.web.data.banners.GroupChangesInfo;
import ru.yandex.autotests.direct.web.objects.banners.BannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.retargeting.RetargetingConditionWeb;
import ru.yandex.autotests.direct.web.pages.mediaplans.MultiEditMediaplanPage;
import ru.yandex.autotests.direct.web.pages.mediaplans.blocks.PhrasesActionPopupBlock;
import ru.yandex.autotests.direct.web.steps.CommonSteps;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;
import ru.yandex.qatools.htmlelements.loader.HtmlElementLoader;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import java.util.concurrent.TimeUnit;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.*;
import static ru.yandex.autotests.direct.web.util.matchers.CollectionItemMatcher.allItemsOfCollection;
import static ru.yandex.autotests.direct.web.util.matchers.webdriver.HasURL.hasURL;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.should;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.timeoutHasExpired;

/**
 * User: alexey-n
 * Date: 27.08.13
 * Time: 16:14
 */
public class MultiEditMediaplanPageSteps extends BaseSteps {

    private MultiEditMediaplanPage onMultiEditMediaplanPage() {
        return MultiEditMediaplanPage.getInstance(MultiEditMediaplanPage.class, config);
    }


    private PhrasesActionPopupBlock onPhrasesActionPopup() {
        return HtmlElementLoader.create(PhrasesActionPopupBlock.class, config.getDriver());
    }

    public CommonSteps inOperatingSystem() {
        return BaseSteps.getInstance(CommonSteps.class, config);
    }

    public CommonSteps getCommonSteps() {
        return CommonSteps.getInstance(CommonSteps.class, config);
    }

    @Step("Нажимаем 'Далее'")
    public void goNext() {
        String currntURL = config.getDriver().getCurrentUrl();
        onMultiEditMediaplanPage().clickNextButton();
        getCommonSteps().shouldSeeBrowser(CoreMatchers.not(hasURL(equalToIgnoringCase(currntURL))));
    }

    @Step("Нажимаем 'Далее'")
    public void goNextWithoutCheck() {
        onMultiEditMediaplanPage().clickNextButton();
    }

    @Step("Нажимаем 'Назад'")
    public void goBack() {
        String currentURL = config.getDriver().getCurrentUrl();
        onMultiEditMediaplanPage().clickPrevButton();
        getCommonSteps().shouldSeeBrowser(CoreMatchers.not(hasURL(equalToIgnoringCase(currentURL))));
    }


    @Step("Проверяем параметры медиаплана")
    public void shouldSeeMediaplanParameters(IBeanWrapper<BannerInfoWeb> bannerInfo) {
        BannerInfoWeb expectedMediaplan = bannerInfo.getBean();
        expectedMediaplan.setStatusShow(null); // todo выпилить StatusShow из BannerInfoWeb
        onMultiEditMediaplanPage().forMediaplanID(expectedMediaplan.getBannerId());
        onMultiEditMediaplanPage().checkMediaplanParameters(expectedMediaplan);
        AllureUtils.addJsonAttachment("Ожидаемый медиаплан", bannerInfo.toString());
    }

    @Step("Заполняем параметры медиаплана")
    public void fillMediaplanParameters(IBeanWrapper<BannerInfoWeb> banner) {
        BannerInfoWeb bannerInfo = banner.getBean();
        onMultiEditMediaplanPage().fillMediaplanParameters(bannerInfo.getBannerId(), bannerInfo);
        AllureUtils.addJsonAttachment("Медиаплан", banner.toString());
    }

    @Step("Проверяем, что попам минус слов удовлетворяет условию {0}")
    public void shouldSeeMinusKeyWordsPopup(Long mediaplanID, Matcher matcher) {
        onMultiEditMediaplanPage().checkMinusKeyWordsPopup(mediaplanID, matcher);
    }

    @Step("Проверяем, что список фраз для медиаплана {1} удовлетворяет условию {0}")
    public void shouldSeePhraseList(Matcher matcher, Long mediaplanID) {
        onMultiEditMediaplanPage().checkMediaplanPhraseList(matcher, mediaplanID);
    }

    @Step("Удаляем все фразы для медиаплана {0}")
    public void removeAllPhrases(Long mediaplanID) {
        onMultiEditMediaplanPage().openPhraseActionPopup(mediaplanID);
        onPhrasesActionPopup().clickRemoveAllPhrases();
        assertThat("попап действий с фразами не соответсвует ожиданиям", onPhrasesActionPopup(),
                should(not(WebElementMatchers.isDisplayed())).whileWaitingUntil(timeoutHasExpired(
                        TimeUnit.SECONDS.toMillis(DirectTestRunProperties.getInstance().getDirectWebWebdriverImplicityWaitTimeoutSec()))));
    }

    @Step("Устанавливаем первую букву строчной для всех фраз медиаплана {0} ")
    public void toLowerCaseFirstLetterAllPhrases(Long mediaplanID) {
        onMultiEditMediaplanPage().openPhraseActionPopup(mediaplanID);
        onPhrasesActionPopup().clickToLowerCaseFirstLetterAllPhrases();
        assertThat("попап действий с фразами не соответсвует ожиданиям", onPhrasesActionPopup(),
                should(not(WebElementMatchers.isDisplayed())).whileWaitingUntil(timeoutHasExpired(
                        TimeUnit.SECONDS.toMillis(DirectTestRunProperties.getInstance().getDirectWebWebdriverImplicityWaitTimeoutSec()))));
    }

    @Step("Устанавливаем первую букву заглавной для всех фраз медиаплана {0} ")
    public void toUpperCaseFirstLetterAllPhrases(Long mediaplanID) {
        onMultiEditMediaplanPage().openPhraseActionPopup(mediaplanID);
        onPhrasesActionPopup().clickToUpperCaseFirstLetterAllPhases();
        assertThat("попап действий с фразами не соответсвует ожиданиям", onPhrasesActionPopup(),
                should(not(WebElementMatchers.isDisplayed())).whileWaitingUntil(timeoutHasExpired(
                        TimeUnit.SECONDS.toMillis(DirectTestRunProperties.getInstance().getDirectWebWebdriverImplicityWaitTimeoutSec()))));
    }

    @Step("Убираем кавычки для всех фраз медиаплана {0}")
    public void unwrapQuotesAllPhrases(Long mediaplanID) {
        onMultiEditMediaplanPage().openPhraseActionPopup(mediaplanID);
        onPhrasesActionPopup().clickUnwrapQuotesAllPhrases();
        assertThat("попап действий с фразами не соответсвует ожиданиям", onPhrasesActionPopup(),
                should(not(WebElementMatchers.isDisplayed())).whileWaitingUntil(timeoutHasExpired(
                        TimeUnit.SECONDS.toMillis(DirectTestRunProperties.getInstance().getDirectWebWebdriverImplicityWaitTimeoutSec()))));
    }

    @Step("Устанавливаем кавычки для всех фраз медиаплана {0}")
    public void wrapQuotesAllPhrases(Long mediaplanID) {
        onMultiEditMediaplanPage().openPhraseActionPopup(mediaplanID);
        onPhrasesActionPopup().clickWrapQuotesAllPhrases();
        assertThat("попап действий с фразами не соответсвует ожиданиям", onPhrasesActionPopup(),
                should(not(WebElementMatchers.isDisplayed())).whileWaitingUntil(timeoutHasExpired(
                        TimeUnit.SECONDS.toMillis(DirectTestRunProperties.getInstance().getDirectWebWebdriverImplicityWaitTimeoutSec()))));
    }

    @Step("Проверяем, что в окне выбора фразы фраза удовлетворяет условию {0}, регионы - условию {1}")
    public void shouldSeeChoosePhraseWindow(String phrase, String regions) {
        onMultiEditMediaplanPage().checkChoosePhraseWindow(phrase, regions);
    }

    @Step("Проверяем, что в окне отклонения фразы фраза удовлетворяет условию {0}, регионы - условию {1}")
    public void shouldSeeAdjustPhraseWindow(String phrase, String regions) {
        onMultiEditMediaplanPage().checkAdjustPhraseWindow(phrase, regions);
    }

    @Step("Открываем окно выбора фразы для медиаплана {0} и фразы {1}")
    public void openChoosePhraseWindow(Long mediaplanID, String phrase) {
        onMultiEditMediaplanPage().choosePhrase(mediaplanID, phrase);
    }

    @Step("Открываем окно отклонения фразы для медиаплана {0} и фразы {1}")
    public void openAdjustPhraseWindow(Long mediaplanID, String phrase) {
        onMultiEditMediaplanPage().adjustPhrase(mediaplanID, phrase);
    }

    @Step("Проверяем, что блок медиаплана {0} удовлетворяет условию {1}")
    public void shouldSeeMediaplanAdBlock(Long mediaplanID, Matcher matcher) {
        onMultiEditMediaplanPage().checkMediaplanAdBlock(mediaplanID, matcher);
    }

    @Step("Проверяем, что все фразы медиаплана {0} содержат минус слово {1}")
    public void shouldSeeMinusKeywordsForAllPhrasesInMediaplanAd(Long mediaplanID, String minusKeyword) {
        onMultiEditMediaplanPage().checkMediaplanPhraseList(
                allItemsOfCollection(containsString(minusKeyword)), mediaplanID);
    }

    @Step("Проверяем, что домен медиаплана {0} равен {1}")
    public void shouldSeeDomain(Long mediaplanID, String domain) {
        onMultiEditMediaplanPage().checkDomain(mediaplanID, domain);
    }

    @Step("Очищаем фразы для медиаплана {0}")
    public void clearMediaplanPhrasesText(Long mediaplanID) {
        onMultiEditMediaplanPage().clickOnClearMediaplanPhrasesTextInput(mediaplanID);
    }

    @Step("Добавляем условие ретаргетинга {1} для медиаплана {0}")
    public void addSavedRetargetingCondition(Long mediaplanID, String conditionName) {
        onMultiEditMediaplanPage().addSavedRetargetingCondition(mediaplanID, conditionName);
    }

    @Step("Удаляем условие ретаргетинга {1} для медиаплана {0}")
    public void deleteRetargetingCondition(Long mediaplanID, String conditionName) {
        onMultiEditMediaplanPage().deleteRetargetingCondition(mediaplanID, conditionName);
    }

    @Step("Проверяем, что для медиаплана {0} поля являются нередактируемыми")
    public void shouldSeeNotEditableFields(Long mediaplanID,
                                           IBeanWrapper<RetargetingConditionWeb> conditionWebWrapped) {
        onMultiEditMediaplanPage().checkCantEditFields(mediaplanID, conditionWebWrapped.getBean());
        AllureUtils.addJsonAttachment("Проверяемые поля", conditionWebWrapped.toString());
    }

    @Step("Применяем групповые изменения для медиапланов")
    public void applyGroupChanges(IBeanWrapper<GroupChangesInfo> groupChangesInfo) {
        AllureUtils.addJsonAttachment("Параметры групповых изменений", groupChangesInfo.toString());
        onMultiEditMediaplanPage().fillGroupEditParameters(groupChangesInfo.getBean());
    }

    @Step("Открываем вкладку {0} на попапе групповых изменений")
    public void openGroupChangesTab(IBeanWrapper<GroupChangesBlockTabs> groupChangesBlockTabs) {
        onMultiEditMediaplanPage().openGroupChangesTab(groupChangesBlockTabs.getBean());
    }
}
