package ru.yandex.autotests.direct.web.steps.mediaplan;


import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.web.data.mediaplan.RequestMediaplanInfo;
import ru.yandex.autotests.direct.web.pages.mediaplans.SendRequestMediaplanPage;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

/**
 * Created with IntelliJ IDEA.
 * User: alexey-n
 * Date: 03.12.13
 */
public class SendRequestMediaplanSteps extends BaseSteps {


    private SendRequestMediaplanPage onSendRequestMediaplanPage() {
        return SendRequestMediaplanPage.getInstance(SendRequestMediaplanPage.class, config);
    }

    @Step("Отправить запрос медиаплана")
    public void sendRequestMediaplan(IBeanWrapper<RequestMediaplanInfo> requestMediaplanInfoWrapped) {
        onSendRequestMediaplanPage().fillRequestParameters(requestMediaplanInfoWrapped.getBean());
        takeScreenshot();
        onSendRequestMediaplanPage().sendRequest();
        AllureUtils.addJsonAttachment("Запрос", requestMediaplanInfoWrapped.toString());
    }
}
