package ru.yandex.autotests.direct.web.steps.payment;

import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.web.pages.payment.BalanceCheckOutPage;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 14.07.14
 */
public class BalanceCheckOutPageSteps extends BaseSteps {

    private BalanceCheckOutPage onBalanceCheckOutPage() {
        return BasePageObject.getInstance(BalanceCheckOutPage.class, config);
    }

    @Step("Проверяем, что общая сумма оплаты удовлетворяет условию {0}")
    public void shouldSeeTotalPayable(Matcher matcher) {
        onBalanceCheckOutPage().checkTotalPayable(matcher);
    }
}
