package ru.yandex.autotests.direct.web.steps.payment;

import org.hamcrest.Matcher;

import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.web.helpers.FinanceApiHelper;
import ru.yandex.autotests.direct.web.objects.transfer.PayCampElement;
import ru.yandex.autotests.direct.web.objects.transfer.PaymentMoney;
import ru.yandex.autotests.direct.web.pages.payment.PayWithCashBalancePage;
import ru.yandex.autotests.direct.web.pages.payment.PaymentPage;
import ru.yandex.autotests.direct.web.steps.AddressBarSteps;
import ru.yandex.autotests.direct.web.steps.AlertSteps;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

import static org.hamcrest.core.IsEqual.equalTo;
import static ru.yandex.autotests.direct.web.util.OperationSystemUtils.sleep;
import static ru.yandex.autotests.direct.web.util.testinterfaces.helpers.URLParametersHelper.getUrlParameterByName;

public class PaymentSteps extends BaseSteps {

    private PaymentPage onPaymentPage() {
        return BasePageObject.getInstance(PaymentPage.class, config);
    }

    private PayWithCashBalancePage onPayWithCashBalancePage() {
        return BasePageObject.getInstance(PayWithCashBalancePage.class, config);
    }

    @Step("Производим оплату на странице оплаты")
    public void payOnPaymentPage(IBeanWrapper<PaymentMoney> paymentMoney, User paymentClient,
            MoneyCurrency moneyCurrency)
    {
        for (PayCampElement payCampElement : paymentMoney.getBean().getPayCampElementList()) {
            getInstance(AddressBarSteps.class, config)
                    .openPaymentPageFor(paymentClient, payCampElement.getCampaignId());
            onPaymentPage().pay(Float.valueOf(payCampElement.getSum()));
            String requestID = getUrlParameterByName(config.getDriver().getCurrentUrl()
                    , PaymentMoney.REQUEST_ID_PARAMETER_NAME);
            checkRequest(paymentClient, requestID,
                    (Money.valueOf(Float.valueOf(payCampElement.getSum())
                            , moneyCurrency.getCurrency()).addVAT().floatValue()));
        }

    }

    @Step("Производим оплату на странице оплаты с учетом НДС")
    public void payOnPaymentPageWithVAT(IBeanWrapper<PaymentMoney> paymentMoney, User paymentClient) {
        for (PayCampElement payCampElement : paymentMoney.getBean().getPayCampElementList()) {
            getInstance(AddressBarSteps.class, config)
                    .openPaymentPageFor(paymentClient, payCampElement.getCampaignId());
            onPaymentPage().payWithVAT(Float.valueOf(payCampElement.getSum()));
            sleep(5000);
            String requestID = getUrlParameterByName(config.getDriver().getCurrentUrl()
                    , PaymentMoney.REQUEST_ID_PARAMETER_NAME);
            checkRequest(paymentClient, requestID, Float.valueOf(payCampElement.getSum()));
        }
    }

    @Step("Производим оплату на странице оплаты и проверяем предупреждение")
    public void payOnPaymentPageWithExpectedAlert(IBeanWrapper<PaymentMoney> paymentMoney, Matcher<String> matcher) {
        for (PayCampElement payCampElement : paymentMoney.getBean().getPayCampElementList()) {
            getInstance(AddressBarSteps.class, config).openPaymentPageFor(payCampElement.getCampaignId());
            onPaymentPage().pay(Float.valueOf(payCampElement.getSum()));
            getInstance(AlertSteps.class, config).accept(matcher);
        }
    }

    @Step("Производим оплату на странице оплаты с учетом НДС и проверяем предупреждение")
    public void payOnPaymentPageWithVATWithExpectedAlert(IBeanWrapper<PaymentMoney> paymentMoney,
            Matcher<String> matcher)
    {
        for (PayCampElement payCampElement : paymentMoney.getBean().getPayCampElementList()) {
            getInstance(AddressBarSteps.class, config).openPaymentPageFor(payCampElement.getCampaignId());
            onPaymentPage().payWithVAT(Float.valueOf(payCampElement.getSum()));
            getInstance(AlertSteps.class, config).accept(matcher);
        }
    }

    @Step("Отправляем форму оплаты на странице оплаты")
    public void submitPaymentFormOnPaymentPage(IBeanWrapper<PaymentMoney> paymentMoney, User paymentClient) {
        for (PayCampElement payCampElement : paymentMoney.getBean().getPayCampElementList()) {
            getInstance(AddressBarSteps.class, config)
                    .openPaymentPageFor(paymentClient, payCampElement.getCampaignId());
            onPaymentPage().pay(Float.valueOf(payCampElement.getSum()));
        }
    }

    @Step("Отправляем форму оплаты с учетом НДС на странице оплаты")
    public void submitPaymentFormOnPaymentPageWithVAT(IBeanWrapper<PaymentMoney> paymentMoney, User paymentClient) {
        for (PayCampElement payCampElement : paymentMoney.getBean().getPayCampElementList()) {
            getInstance(AddressBarSteps.class, config)
                    .openPaymentPageFor(paymentClient, payCampElement.getCampaignId());
            onPaymentPage().payWithVAT(Float.valueOf(payCampElement.getSum()));
        }
    }

    @Step("Проверяем сумму в заказе")
    public void checkRequest(User user, String requestID, float sum) {
        new FinanceApiHelper().requestAmountShouldBe(user, requestID, equalTo(sum));
    }
}