package ru.yandex.autotests.direct.web.steps.payment;

import org.hamcrest.Matcher;
import org.openqa.selenium.TimeoutException;

import ru.yandex.autotests.direct.web.pages.payment.yandex.money.YandexMoneyPage;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

/**
 * User: buhter
 * Date: 29.06.13
 * Time: 21:28
 */
public class YandexMoneySteps extends BaseSteps {

    private YandexMoneyPage onYandexMoneyPage() {
        return BasePageObject.getInstance(YandexMoneyPage.class, config);
    }

    @Step("Логинимся")
    public void login(User account) {
        onYandexMoneyPage().onLoginForm().login(account);
    }

    @Step("Ожидаем заголовка {0} в течение {1}")
    public void waitForTitle(Matcher<String> matcher, long timeoutInSeconds) {
        try {
            onYandexMoneyPage().shouldSeeTitle(matcher, timeoutInSeconds);
        } catch (Error e) {
            throw new TimeoutException("Превышено время ожидания открытия страницы" + matcher.toString());
        }
    }

    @Step("Логинимся новым логином")
    public void loginInNewPassport(User account) {
        onYandexMoneyPage().onLoginForm().newLogin(account);
    }

    @Step("Подтверждаем доступ")
    public void confirmAccess(String paymentPass) {
        onYandexMoneyPage().confirm(paymentPass);
    }

    @Step("Нажимаем заплатить")
    public void accept() {
        onYandexMoneyPage().accept();
    }

}


