package ru.yandex.autotests.direct.web.steps.representatives.agency;

import ru.yandex.autotests.direct.utils.beans.IBeanWrapper;
import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.pages.representatives.agency.AddAgRepPage;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;

/**
 * @author Alex-samo (alex-samo@yandex-team.ru)
 *         Date: 10.10.13
 */
public class AddAgRepPageSteps extends BaseSteps {

    public AddAgRepPage onAddAgRep() {
        return AddAgRepPage.getInstance(AddAgRepPage.class, config);
    }

    @Step("Заполняем данные представителя")
    public void fillRepresentativePersonalData(IBeanWrapper<AccountWeb> accountWeb) {
        AllureUtils.addJsonAttachment("Данные представителя", accountWeb.toString());
        onAddAgRep().fillRepresentativePersonalData(accountWeb.getBean());
    }

    @Step("Кликамем зарегистрировать представителя")
    public void registerRepresentative() {
        onAddAgRep().clickOnRegisterButton();
    }

    @Step("Кликаем сабмит")
    public void submit() {
        onAddAgRep().clickOnSubmitButton();
    }
}
